/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataObjectEncodingUtils;
import oracle.stellent.ridc.model.impl.DataResultSetImpl;

public class DataResultSetRow
implements DataObject {
    private DataResultSetImpl m_resultSet = null;
    private List<String> m_values = null;

    public DataResultSetRow(DataResultSetImpl resultSet, List<String> values) {
        this.m_resultSet = resultSet;
        this.m_values = values;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return DataObjectEncodingUtils.getBoolean(this, name, defaultValue);
    }

    @Override
    public void setBoolean(String name, boolean value) {
        DataObjectEncodingUtils.setBoolean(this, name, value);
    }

    @Override
    public void setDate(String name, Date date) {
        DataObjectEncodingUtils.setDate(this, name, date);
    }

    @Override
    public Date getDate(String name) {
        Calendar calender = this.getCalendar(name);
        return calender != null ? calender.getTime() : null;
    }

    @Override
    public Calendar getCalendar(String name) {
        return DataObjectEncodingUtils.getCalendar(this, name);
    }

    @Override
    public int getInteger(String name) {
        return DataObjectEncodingUtils.getInteger(this, name, -1);
    }

    @Override
    public int size() {
        return this.m_values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_values.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.m_resultSet.hasField((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        return this.m_values.contains((String)value);
    }

    @Override
    public String get(Object key) {
        int index;
        if (key instanceof String && (index = this.m_resultSet.getFieldIndex((String)key)) != -1) {
            return this.m_values.get(index);
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        int index = this.m_resultSet.getFieldIndex(key);
        if (index == -1) {
            throw new IllegalArgumentException(RIDCMessages.model_resultset_row_invalid_key(key).toString());
        }
        return this.m_values.set(index, value);
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException(RIDCMessages.model_resultset_rows_cannot_remove_data().toString());
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        throw new UnsupportedOperationException(RIDCMessages.model_resultset_rows_not_modifiable().toString());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(RIDCMessages.model_resultset_rows_not_modifiable().toString());
    }

    @Override
    public Set<String> keySet() {
        List<DataResultSet.Field> fields = this.m_resultSet.getFields();
        HashSet<String> set = new HashSet<String>(fields.size());
        for (DataResultSet.Field field : fields) {
            set.add(field.getName());
        }
        return set;
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableList(this.m_values);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        List<DataResultSet.Field> fields = this.m_resultSet.getFields();
        HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
        for (int i = 0; i < fields.size(); ++i) {
            DataResultSet.Field field = fields.get(i);
            final String name = field.getName();
            final String value = this.m_values.get(i);
            set.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return name;
                }

                @Override
                public String getValue() {
                    return value;
                }

                @Override
                public String setValue(String value2) {
                    throw new UnsupportedOperationException(RIDCMessages.model_resultset_rows_not_modifiable().toString());
                }
            });
        }
        return set;
    }
}

