/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.serialize;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import oracle.stellent.ridc.common.util.NumberTools;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.DataResultSet;
import oracle.stellent.ridc.model.impl.DataObjectImpl;
import oracle.stellent.ridc.model.serialize.HdaSerializerUtils;

public class HdaBinderSerializer
implements Serializable {
    public static final String[] DATA_TYPES = new String[]{"Properties", "OptionList", "ResultSet", "end"};
    private String m_encoding = null;
    private DataFactory m_dataFactory = null;

    public HdaBinderSerializer(String encoding, DataFactory dataFactory) {
        this.m_encoding = encoding;
        this.m_dataFactory = dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.m_dataFactory;
    }

    public DataBinder parseBinder(InputStream inputStream) throws IOException {
        return this.parseBinder(new InputStreamReader(inputStream, this.getEncoding()));
    }

    public DataBinder parseBinder(Reader inputReader) throws IOException {
        BufferedReader reader = null;
        reader = inputReader instanceof BufferedReader ? (BufferedReader)inputReader : new BufferedReader(inputReader);
        DataBinder dataBinder = this.getDataFactory().createBinder();
        String[] types = DATA_TYPES;
        String line = null;
        String name = "";
        while ((line = this.readLine(reader, true)) != null) {
            if (line.length() <= 1) continue;
            int type = -1;
            for (int i = 0; i < types.length; ++i) {
                if (line.charAt(0) != '@') {
                    int loc = line.indexOf("<?hda");
                    if (loc == 0) {
                        type = 4;
                        break;
                    }
                    loc = line.indexOf("Content-");
                    if (loc == 0) {
                        type = 4;
                        break;
                    }
                    loc = line.indexOf("StatusCode");
                    if (loc < 0) {
                        loc = line.indexOf("StatusMessage");
                    }
                    if (loc >= 0) {
                        this.parseNameValue(dataBinder.getLocalData(), line.substring(loc), "=");
                        continue;
                    }
                    loc = line.indexOf(": ");
                    if (loc < 0) continue;
                    type = 4;
                    break;
                }
                if (!line.startsWith("@" + types[i])) continue;
                type = i;
                int index = line.indexOf(" ");
                if (index < 0) continue;
                name = line.substring(index).trim();
                break;
            }
            boolean isResultSet = false;
            switch (type) {
                case 0: {
                    this.parseProperties(dataBinder, name, reader);
                    break;
                }
                case 1: {
                    this.parseOptionList(dataBinder, name, reader);
                    break;
                }
                case 2: {
                    this.parseResultSet(dataBinder, name, reader);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    this.readToEnd(reader);
                }
            }
            if (!isResultSet) continue;
            break;
        }
        this.getDataFactory().synchronizeLocal(dataBinder, DataFactory.Direction.IN);
        return dataBinder;
    }

    public void serializeBinder(OutputStream outputStream, DataBinder dataBinder) throws IOException {
        this.serializeBinder(new OutputStreamWriter(outputStream, this.getEncoding()), dataBinder);
    }

    public void serializeBinder(Writer writer, DataBinder dataBinder) throws IOException {
        BufferedWriter bufferedWriter = null;
        bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.getDataFactory().synchronizeLocal(dataBinder, DataFactory.Direction.OUT);
        this.packageProperties(bufferedWriter, dataBinder.getLocalData(), "LocalData");
        for (String setName : dataBinder.getResultSetNames()) {
            DataResultSet resultSet = dataBinder.getResultSet(setName);
            this.packageResultSet(bufferedWriter, resultSet, setName);
        }
        for (String name : dataBinder.getOptionListNames()) {
            List<String> optionList = dataBinder.getOptionList(name);
            this.packageOptionList(bufferedWriter, optionList, name);
        }
        try {
            bufferedWriter.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    protected boolean parseProperties(DataBinder dataBinder, String name, BufferedReader reader) throws IOException {
        DataObject props = null;
        props = name.equals("Environment") ? new DataObjectImpl() : dataBinder.getLocalData();
        return this.readProperties(reader, props, "@end", true);
    }

    protected boolean readProperties(BufferedReader reader, DataObject props, String endMark, boolean isJava) throws IOException {
        String line = "";
        while (!(line = this.readLine(reader, false)).equals(endMark)) {
            int index;
            if (isJava) {
                line = HdaSerializerUtils.decode(line);
            }
            if ((index = line.indexOf(61)) < 0) {
                return false;
            }
            String name = line.substring(0, index);
            String value = line.substring(index + 1);
            props.put(name, value);
        }
        return true;
    }

    protected boolean parseNameValue(DataObject dataObject, String envPair, String delimiter) {
        String key = null;
        String value = null;
        int index = envPair.indexOf(delimiter);
        if (index < 0) {
            key = envPair;
            value = "";
        } else {
            key = envPair.substring(0, index);
            value = index + 1 == envPair.length() ? "" : envPair.substring(index + 1);
        }
        dataObject.put(key, value);
        return true;
    }

    protected void readToEnd(BufferedReader reader) throws IOException {
        String line = "";
        while (!(line = this.readLine(reader, false)).equals("@end")) {
        }
    }

    protected void parseOptionList(DataBinder dataBinder, String name, BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> options = new ArrayList<String>();
        while ((line = this.readLine(reader, false)) != null && !line.startsWith("@end")) {
            String value = line.trim();
            options.add(value);
        }
        dataBinder.addOptionList(name, options);
    }

    protected String readLine(BufferedReader reader, boolean suppress) throws IOException {
        String line = reader.readLine();
        if (line == null && !suppress) {
            throw new IOException(RIDCMessages.serialize_input_terminated_before_read_line().toString());
        }
        return line;
    }

    protected void parseResultSet(DataBinder dataBinder, String rName, BufferedReader reader) throws IOException {
        DataResultSet resultSet = this.getDataFactory().createResultSet();
        List<DataResultSet.Field> fields = this.readResultSetHeader(reader);
        resultSet.setFields(fields);
        String line = null;
        boolean foundAt = false;
        int rowIndex = 0;
        while ((line = reader.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == '@') {
                foundAt = true;
                break;
            }
            ++rowIndex;
            ArrayList<String> values = new ArrayList<String>();
            String value = HdaSerializerUtils.decode(line);
            values.add(value);
            for (int j = 1; j < fields.size(); ++j) {
                line = reader.readLine();
                if (line == null) {
                    throw new IOException(RIDCMessages.serialize_parse_resultset_error(rowIndex, j).toString());
                }
                line = HdaSerializerUtils.decode(line);
                values.add(line);
            }
            resultSet.addRow(values);
        }
        if (!foundAt || !line.startsWith("@end")) {
            throw new IOException("The result set is malformed.");
        }
        dataBinder.addResultSet(rName, resultSet);
    }

    protected List<DataResultSet.Field> readResultSetHeader(BufferedReader bReader) throws IOException {
        String line = bReader.readLine();
        int numFields = Integer.parseInt(line);
        ArrayList<DataResultSet.Field> fields = new ArrayList<DataResultSet.Field>();
        for (int i = 0; i < numFields; ++i) {
            DataResultSet.Field field = null;
            line = bReader.readLine();
            String fieldData = HdaSerializerUtils.decode(line);
            int index = fieldData.indexOf(" ");
            if (index > 0) {
                String fieldName = fieldData.substring(0, index);
                field = new DataResultSet.Field(fieldName);
                if ((fieldData = fieldData.substring(index).trim()).length() > 0) {
                    int fieldType = this.getFieldType(fieldData);
                    if (fieldType > 0) {
                        DataResultSet.Field.Type type = DataResultSet.Field.Type.getTypeFromOrdinal(fieldType - 1);
                        field.setType(type);
                    }
                    if (fieldType >= this.getTypeIndex(DataResultSet.Field.Type.BOOLEAN) && fieldType <= this.getTypeIndex(DataResultSet.Field.Type.BINARY) || fieldType == this.getTypeIndex(DataResultSet.Field.Type.DECIMAL)) {
                        if ((fieldData = fieldData.substring(String.valueOf(fieldType).length()).trim()).length() > 0) {
                            if (fieldType == this.getTypeIndex(DataResultSet.Field.Type.DECIMAL)) {
                                int decimalSeparator = fieldData.indexOf(44);
                                String precisionStr = fieldData;
                                String scaleStr = null;
                                if (decimalSeparator > 0) {
                                    precisionStr = fieldData.substring(0, decimalSeparator).trim();
                                    if (fieldData.length() > decimalSeparator + 1) {
                                        scaleStr = fieldData.substring(decimalSeparator + 1).trim();
                                    }
                                }
                                field.setMaxLen(NumberTools.parseInteger(precisionStr, 1));
                                field.setScale(NumberTools.parseInteger(scaleStr, 1));
                            } else {
                                field.setMaxLen(NumberTools.parseInteger(fieldData, 0));
                            }
                        }
                        if (field.getMaxLen() > 0) {
                            field.setFixedLen(true);
                        }
                    }
                }
            }
            if (field == null) {
                field = new DataResultSet.Field(fieldData);
            }
            fields.add(field);
        }
        return fields;
    }

    protected int getTypeIndex(DataResultSet.Field.Type type) {
        return type.ordinal() + 1;
    }

    protected int getFieldType(String fieldData) {
        char typeChar = fieldData.charAt(0);
        String typeStr = String.valueOf(typeChar);
        if (fieldData.length() > 1 && (typeChar = fieldData.charAt(1)) >= '0' && typeChar <= '9') {
            typeStr = typeStr + String.valueOf(typeChar);
        }
        int fieldType = Integer.parseInt(typeStr);
        return fieldType;
    }

    protected void packageProperties(Writer writer, DataObject dataObject, String name) throws IOException {
        if (dataObject.size() == 0) {
            return;
        }
        StringBuffer str = new StringBuffer("@Properties ");
        str.append(HdaSerializerUtils.encode(name));
        str.append("\n");
        try {
            for (String key : dataObject.keySet()) {
                String value = (String)dataObject.get(key);
                String nmeValue = key + "=" + value;
                str.append(HdaSerializerUtils.encode(nmeValue));
                str.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        str.append("@end\n");
        writer.write(str.toString());
    }

    protected void packageResultSet(Writer writer, DataResultSet aSet, String name) throws IOException {
        StringBuffer strBuf = new StringBuffer("@ResultSet " + HdaSerializerUtils.encode(name) + "\n");
        try {
            int numOfFields = aSet.getFields().size();
            strBuf.append(Integer.toString(numOfFields));
            strBuf.append('\n');
            for (DataResultSet.Field field : aSet.getFields()) {
                strBuf.append(HdaSerializerUtils.encode(field.getName()));
                if (field.isFixedLen() || field.getType() != DataResultSet.Field.Type.STRING) {
                    int fieldTypeIndex = field.getType().ordinal() + 1;
                    String typeInfo = " " + String.valueOf(fieldTypeIndex);
                    typeInfo = !field.isFixedLen() ? typeInfo + '\n' : typeInfo + ' ';
                    strBuf.append(typeInfo);
                    if (!field.isFixedLen()) continue;
                    strBuf.append(Integer.toString(field.getMaxLen()));
                    if (field.getType() == DataResultSet.Field.Type.DECIMAL) {
                        strBuf.append("," + field.getScale());
                    }
                    strBuf.append('\n');
                    continue;
                }
                strBuf.append('\n');
            }
            for (DataObject row : aSet.getRows()) {
                for (DataResultSet.Field field : aSet.getFields()) {
                    strBuf.append(HdaSerializerUtils.encode((String)row.get(field.getName())));
                    strBuf.append('\n');
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        strBuf.append("@end\n");
        writer.write(strBuf.toString());
    }

    protected void packageOptionList(Writer writer, List<String> options, String name) throws IOException {
        String str = "@OptionList " + HdaSerializerUtils.encode(name) + "\n";
        try {
            for (String option : options) {
                option = HdaSerializerUtils.encode(option);
                str = str + option + "\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        str = str + "@end\n";
        writer.write(str);
    }

    protected byte[] getBytes(String str) throws UnsupportedEncodingException {
        if (this.m_encoding == null) {
            return str.getBytes();
        }
        return str.getBytes(this.m_encoding);
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.m_encoding = encoding;
        }
    }
}

