/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.serialize;

import java.io.IOException;
import java.io.InputStream;
import oracle.stellent.ridc.common.util.StreamUtil;

public abstract class HdaSerializerUtils {
    public static final String BEGIN_HDA = "<?hda";
    public static final String BEGIN_HDA_NO_HEADER = "@Prop";

    public static String decode(String in) {
        int length = in.length();
        if (length == 0) {
            return "";
        }
        if (in.indexOf(92) == -1) {
            return in;
        }
        StringBuffer out = new StringBuffer(length);
        int i = 0;
        block3: while (i < length) {
            char ch = in.charAt(i);
            if (++i < length) {
                switch (ch) {
                    case '\\': {
                        char nextCh = in.charAt(i);
                        if (nextCh == 'n' || nextCh == 'r') {
                            ++i;
                            char inch = nextCh == 'n' ? (char)'\n' : '\r';
                            out.append(inch);
                            continue block3;
                        }
                        if (nextCh == '\\') {
                            ++i;
                            out.append('\\');
                            continue block3;
                        }
                        if (nextCh != '@') break;
                        continue block3;
                    }
                }
            }
            out.append(ch);
        }
        return new String(out);
    }

    public static String encode(String in) {
        boolean needsEncoding = false;
        for (int i = 0; i < in.length() && !needsEncoding; ++i) {
            char c = in.charAt(i);
            needsEncoding = c == '\n' || c == '\r' || c == '\\' || c == '@';
        }
        if (!needsEncoding) {
            return in;
        }
        int length = in.length();
        StringBuffer out = new StringBuffer(length);
        block5: for (int i = 0; i < length; ++i) {
            char ch = in.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    out.append('\\');
                    char outch = ch == '\n' ? (char)'n' : 'r';
                    out.append(outch);
                    continue block5;
                }
                case '@': 
                case '\\': {
                    out.append('\\');
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return new String(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormatType determineFormat(InputStream inputStream, String encoding) throws IOException {
        FormatType formatType = FormatType.UNKNOWN_TYPE;
        int length = BEGIN_HDA.getBytes(encoding).length;
        inputStream.mark(length);
        try {
            String begin;
            byte[] buf = StreamUtil.tryRead(inputStream, length);
            formatType = buf.length != length ? FormatType.STREAM_TYPE : (BEGIN_HDA.equals(begin = new String(buf, encoding)) || BEGIN_HDA_NO_HEADER.equals(begin) ? FormatType.HDA_TYPE : FormatType.STREAM_TYPE);
        }
        finally {
            inputStream.reset();
        }
        return formatType;
    }

    public static long readIdcContentLength(InputStream inputStream) throws IOException {
        long contentLength = -1L;
        int length = 24;
        inputStream.mark(length);
        byte[] inByte = StreamUtil.tryRead(inputStream, length);
        if (inByte.length == 0) {
            contentLength = 0L;
        } else {
            String fileInfo = new String(inByte);
            int index = fileInfo.indexOf("IDCFILE");
            if (index == -1) {
                inputStream.reset();
            } else {
                String contentLengthString = fileInfo.substring(index + 7, fileInfo.length() - 1).trim();
                try {
                    contentLength = Long.parseLong(contentLengthString);
                }
                catch (NumberFormatException exp) {
                    // empty catch block
                }
            }
        }
        return contentLength;
    }

    public static enum FormatType {
        UNKNOWN_TYPE,
        HDA_TYPE,
        STREAM_TYPE;

    }
}

