/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.model.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.TransferFile;

public class MultipartPostBinderSerializer {
    private String m_encoding = null;
    private DataBinder m_dataBinder = null;
    private String m_breakStr = null;
    private String m_boundary = null;
    private String m_postStr = null;
    private Map<String, String> m_fileHeaders = new HashMap<String, String>();

    public MultipartPostBinderSerializer(DataBinder dataBinder) {
        this.m_dataBinder = dataBinder;
    }

    public MultipartPostBinderSerializer(DataBinder dataBinder, String encoding) {
        this.m_dataBinder = dataBinder;
        this.m_encoding = encoding;
    }

    public DataBinder getDataBinder() {
        return this.m_dataBinder;
    }

    public String getPostString() {
        return this.m_postStr;
    }

    public String getBreakString() {
        return this.m_breakStr;
    }

    public void prepareMultipartPost() {
        this.prepareBoundary();
        this.createPostStr();
        this.createFilePostInfo();
    }

    public long countBytes() {
        long count = 0L;
        try {
            for (String name : this.getDataBinder().getFileNames()) {
                TransferFile file = this.getDataBinder().getFile(name);
                count += file.getContentLength() + (long)this.getBytes("\r\r").length + (long)this.getBytes(this.m_fileHeaders.get(name)).length;
            }
            if (this.getPostString() != null) {
                count += (long)this.getBytes(this.getPostString()).length;
            }
            if (this.getBreakString() != null) {
                count += (long)this.getBytes(this.getBreakString()).length;
            }
        }
        catch (UnsupportedEncodingException exp) {
            exp.printStackTrace();
            throw new RuntimeException(RIDCMessages.serialize_unable_to_count_bytes(exp).toString());
        }
        return count;
    }

    public void writeBinder(OutputStream out) throws IOException {
        out.write(this.getBytes(this.getPostString()));
        this.sendFiles(out);
        out.write(this.getBytes(this.getBreakString()));
        out.flush();
    }

    protected void prepareBoundary() {
        Random gen = new Random();
        this.m_boundary = "----------------" + String.valueOf(gen.nextLong());
        this.m_breakStr = "--" + this.m_boundary + "\r\n";
    }

    protected void createPostStr() {
        StringBuffer buff = new StringBuffer();
        buff.append("JavaBoundary=");
        buff.append(this.m_boundary);
        buff.append("\r\n");
        for (String name : this.getDataBinder().getLocalData().keySet()) {
            String value = this.getDataBinder().getLocal(name);
            buff.append(this.getBreakString());
            buff.append("name=\"");
            buff.append(name);
            buff.append("\"\r\n\r\n");
            buff.append(value);
            buff.append("\r\n");
        }
        this.m_postStr = buff.toString();
    }

    protected void createFilePostInfo() {
        this.m_fileHeaders.clear();
        for (String name : this.getDataBinder().getFileNames()) {
            TransferFile file = this.getDataBinder().getFile(name);
            String header = this.createFilePostInfo(name, file);
            this.m_fileHeaders.put(name, header);
        }
    }

    protected String createFilePostInfo(String name, TransferFile file) {
        StringBuffer fileStr = new StringBuffer(this.getBreakString());
        fileStr.append("name=\"");
        fileStr.append(name);
        fileStr.append("\"; filename=\"");
        fileStr.append(file.getFileName());
        fileStr.append("\"\r\n");
        fileStr.append("Content-Type: ");
        fileStr.append(file.getContentType());
        fileStr.append("\r\n\r\n");
        return fileStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFiles(OutputStream out) throws IOException {
        if (this.getDataBinder().getFileNames() == null) {
            return;
        }
        for (String name : this.getDataBinder().getFileNames()) {
            TransferFile file = this.getDataBinder().getFile(name);
            out.write(this.getBytes(this.createFilePostInfo(name, file)));
            byte[] buffer = new byte[16384];
            InputStream in = file.getInputStream();
            try {
                int read = 0;
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                    file.notifyBufferWrite(read);
                }
            }
            finally {
                StreamUtil.closeStream(in);
            }
            out.write(this.getBytes("\r\r"));
        }
    }

    protected byte[] getBytes(String str) throws UnsupportedEncodingException {
        if (this.m_encoding != null) {
            return str.getBytes(this.m_encoding);
        }
        return str.getBytes();
    }
}

