/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.Connection;
import oracle.stellent.ridc.protocol.ConnectionManager;
import oracle.stellent.ridc.protocol.ConnectionPool;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.impl.BlockingQueueConnectionPool;
import oracle.stellent.ridc.protocol.impl.SimpleConnectionPool;

public class ConnectionPoolManager {
    private Map<String, Class<? extends ConnectionPool>> m_connectionPools = new ConcurrentHashMap<String, Class<? extends ConnectionPool>>();

    public ConnectionPoolManager() {
        this.m_connectionPools.put("pool", BlockingQueueConnectionPool.class);
        this.m_connectionPools.put("simple", SimpleConnectionPool.class);
    }

    public void registerConnectionPool(String name, Class<? extends ConnectionPool> threadingModel) {
        this.m_connectionPools.put(name, threadingModel);
    }

    public boolean isConnectionPoolRegistered(String name) {
        return this.m_connectionPools.containsKey(name);
    }

    public <TCon extends Connection> ConnectionPool<TCon> createConnectionPool(String name, IdcClientConfig config, ConnectionManager<TCon, IdcClientConfig> manager) throws ProtocolException {
        Class<? extends ConnectionPool> modelClass = this.m_connectionPools.get(name);
        ConnectionPool threadModel = null;
        if (modelClass != null) {
            try {
                threadModel = modelClass.newInstance();
                threadModel.initialize(config, manager);
            }
            catch (Exception exp) {
                throw new ProtocolException(RIDCMessages.protocol_unable_to_initialize_threading_model(modelClass.getName()), (Throwable)exp);
            }
        }
        return threadModel;
    }
}

