/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol;

import java.io.IOException;
import java.io.StringReader;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.impl.DataFactoryImpl;
import oracle.stellent.ridc.model.serialize.HdaBinderSerializer;

public class ServiceException
extends IdcClientException {
    private transient DataBinder m_binder = null;
    private HdaBinderSerializer m_serializer = null;
    private String m_responseString = null;

    public ServiceException(String message, HdaBinderSerializer serializer, String response, Throwable cause) {
        super(message, cause);
        this.m_serializer = serializer;
        this.m_responseString = response;
    }

    public ServiceException(String message, HdaBinderSerializer serializer, String response) {
        super(message);
        this.m_serializer = serializer;
        this.m_responseString = response;
    }

    public ServiceException(Throwable cause, DataBinder binder) {
        super(binder.getLocal("StatusMessage"), cause);
        this.m_binder = binder;
    }

    public ServiceException(DataBinder binder) {
        super(binder.getLocal("StatusMessage"));
        this.m_binder = binder;
    }

    public DataBinder getBinder() {
        if (this.m_binder == null) {
            if (this.m_serializer == null) {
                this.m_serializer = new HdaBinderSerializer("UTF-8", new DataFactoryImpl());
            }
            try {
                this.m_binder = this.m_serializer.parseBinder(new StringReader(this.m_responseString));
            }
            catch (IOException e) {
                this.m_binder = this.m_serializer.getDataFactory().createBinder();
                this.m_binder.putLocal("StatusCode", "-1");
                this.m_binder.putLocal("StatusMessage", RIDCMessages.serialize_response_error().toString());
            }
            catch (NullPointerException npe) {
                this.m_binder = this.m_serializer.getDataFactory().createBinder();
                this.m_binder.putLocal("StatusCode", "-1");
                this.m_binder.putLocal("StatusMessage", RIDCMessages.serialize_response_error().toString());
            }
        }
        return this.m_binder;
    }

    public int getStatusCode() {
        return this.getBinder().getLocalData().getInteger("StatusCode");
    }

    public String getStatusMessage() {
        return this.getBinder().getLocal("StatusMessage");
    }
}

