/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.common.io.CloseNotifyInputStream;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.model.serialize.HdaBinderSerializer;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceException;

public class ServiceResponse {
    private DataFactory m_dataFactory = null;
    private String m_encoding = null;
    private Map<String, String> m_headers = null;
    private DataBinder m_binder = null;
    private InputStream m_inputStream = null;
    private ResponseType m_responseType = null;
    private String m_responseString = null;
    private boolean m_connectionReleased = false;
    private ServiceLog m_serviceLog;

    public ServiceResponse(DataFactory dataFactory, String encoding, Map<String, String> headers, InputStream inputStream, ResponseType type) {
        this.m_dataFactory = dataFactory;
        this.m_encoding = encoding;
        this.m_headers = headers;
        this.m_inputStream = inputStream;
        this.m_responseType = type;
    }

    public void setServiceLog(ServiceLog serviceLog) {
        this.m_serviceLog = serviceLog;
    }

    public void setCloseMethod(CloseNotifyInputStream.CloseMethod closeMethod) {
        if (this.m_inputStream instanceof CloseNotifyInputStream) {
            this.m_inputStream = ((CloseNotifyInputStream)this.m_inputStream).getWrappedStream();
        }
        if (closeMethod != null) {
            this.m_inputStream = new CloseNotifyInputStream(this.m_inputStream, closeMethod);
        }
    }

    public boolean isReleased() {
        return this.m_connectionReleased;
    }

    public String getHeader(String name) {
        if (this.m_headers != null) {
            return this.m_headers.get(name);
        }
        return null;
    }

    public Collection<String> getHeaderNames() {
        return this.m_headers.keySet();
    }

    public DataBinder getResponseAsBinder() throws IdcClientException {
        return this.getResponseAsBinder(true);
    }

    public DataBinder getResponseAsBinder(boolean checkErrors) throws IdcClientException {
        if (this.m_binder == null) {
            HdaBinderSerializer serializer = null;
            try {
                serializer = new HdaBinderSerializer(this.m_encoding, this.m_dataFactory);
                this.m_binder = this.m_responseString != null ? serializer.parseBinder(new StringReader(this.m_responseString)) : serializer.parseBinder(this.getResponseStream());
                if (this.m_serviceLog != null) {
                    this.m_serviceLog.logResponseBinder(this.m_binder);
                }
                if (checkErrors && this.m_binder.getLocal("StatusCode") != null && this.m_binder.getLocalData().getInteger("StatusCode") != 0) {
                    if (this.m_responseString == null) {
                        StringWriter stringWriter = new StringWriter();
                        serializer.serializeBinder(stringWriter, this.m_binder);
                        this.m_responseString = stringWriter.toString();
                    }
                    throw new ServiceException(this.m_binder.getLocal("StatusMessage"), serializer, this.m_responseString);
                }
            }
            catch (IOException exp) {
                if (this.m_serviceLog != null) {
                    this.m_serviceLog.logExceptionResponse(exp.getMessage());
                }
                throw new ProtocolException(exp);
            }
            finally {
                StreamUtil.closeStream(this.getResponseStream());
            }
        }
        return this.m_binder;
    }

    public void setResponseStream(InputStream inputStream) {
        this.m_inputStream = inputStream;
        this.m_responseString = null;
        this.m_binder = null;
    }

    public InputStream getResponseStream() {
        return this.m_inputStream;
    }

    public String getResponseAsString() throws IOException {
        if (this.m_responseString == null) {
            this.m_responseString = StreamUtil.getStringFromStream(this.getResponseStream(), this.m_encoding);
        }
        return this.m_responseString;
    }

    public ResponseType getResponseType() {
        return this.m_responseType;
    }

    public void close() {
        StreamUtil.closeStream(this.getResponseStream());
    }

    public static enum ResponseType {
        STREAM,
        BINDER;

    }
}

