/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http;

import java.net.URI;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.common.http.utils.RIDCHttpConstants;
import oracle.stellent.ridc.common.util.StringTools;

public class IdcHttpClientConfig
extends IdcClientConfig {
    public static final String CHUNK_SIZE = "http.chunkSize";
    public static final String PROP_USE_SYSTEM_PROXY = "useSystemProxy";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String PROXY_USERNAME = "http.proxyUsername";
    public static final String PROXY_PASSWORD = "http.proxyPassword";
    public static final String PROXY_REALM = "http.proxyRealm";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String IS_ADMIN_SERVER = "http.isAdminServer";
    public static final String PING_SERVICE = "http.pingService";
    public static final String SECURITY_REALM = "http.securityRealm";
    public static final String CONTENTTYPE_UTF8 = "application/x-www-form-urlencoded; charset=utf-8";
    public static final String DEFAULT_SECURITY_REALM = "myrealm";
    private RIDCHttpConstants.HttpLibrary httpLibrary = RIDCHttpConstants.HttpLibrary.apache3;

    public RIDCHttpConstants.HttpLibrary getHttpLibrary() {
        String libName = this.getProperty("http.library");
        if (RIDCHttpConstants.HttpLibrary.apache3.name().equals(libName)) {
            this.setHttpLibrary(RIDCHttpConstants.HttpLibrary.apache3);
        } else if (RIDCHttpConstants.HttpLibrary.apache4.name().equals(libName)) {
            this.setHttpLibrary(RIDCHttpConstants.HttpLibrary.apache4);
        } else if (RIDCHttpConstants.HttpLibrary.oracle.name().equals(libName)) {
            this.setHttpLibrary(RIDCHttpConstants.HttpLibrary.oracle);
        } else if (RIDCHttpConstants.HttpLibrary.httpurlconnection.name().equals(libName)) {
            this.setHttpLibrary(RIDCHttpConstants.HttpLibrary.httpurlconnection);
        }
        return this.httpLibrary;
    }

    public void setHttpLibrary(RIDCHttpConstants.HttpLibrary httpLibrary) {
        this.httpLibrary = httpLibrary;
    }

    public int getChunkSize() {
        String chunkSize = this.getProperty(CHUNK_SIZE);
        int size = 65536;
        if (!StringTools.isEmpty(chunkSize)) {
            try {
                size = Integer.parseInt(chunkSize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return size;
    }

    public void setChunkSize(int size) {
        this.setProperty(CHUNK_SIZE, String.valueOf(size));
    }

    public boolean isUseSystemProxy() {
        return !"false".equals(this.getProperty(PROP_USE_SYSTEM_PROXY));
    }

    public void setUseSystemProxy(boolean useSystemProxy) {
        this.setProperty(PROP_USE_SYSTEM_PROXY, String.valueOf(useSystemProxy));
    }

    public String getProxyHost() {
        return this.isUseSystemProxy() ? System.getProperty(PROXY_HOST) : this.getProperty(PROXY_HOST);
    }

    public void setProxyHost(String proxyHost) {
        this.setProperty(PROXY_HOST, proxyHost);
    }

    public int getProxyPort() {
        String proxyPort = this.isUseSystemProxy() ? System.getProperty(PROXY_PORT) : this.getProperty(PROXY_PORT);
        int port = 80;
        if (!StringTools.isEmpty(proxyPort)) {
            try {
                port = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }

    public void setProxyPort(int port) {
        this.setProperty(PROXY_PORT, String.valueOf(port));
    }

    public String getNonProxyHosts() {
        return this.isUseSystemProxy() ? System.getProperty(NON_PROXY_HOSTS) : this.getProperty(NON_PROXY_HOSTS);
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.setProperty(NON_PROXY_HOSTS, nonProxyHosts);
    }

    public String getProxyUsername() {
        return this.isUseSystemProxy() ? System.getProperty(PROXY_USERNAME) : this.getProperty(PROXY_USERNAME);
    }

    public void setProxyUsername(String proxyUsername) {
        this.setProperty(PROXY_USERNAME, proxyUsername);
    }

    public String getProxyPassword() {
        return this.getProperty(PROXY_PASSWORD);
    }

    public void setProxyPassword(String proxyPassword) {
        this.setProperty(PROXY_PASSWORD, proxyPassword);
    }

    public void setProxyRealm(String proxyRealm) {
        this.setProperty(PROXY_REALM, proxyRealm);
    }

    public String getProxyRealm() {
        return this.getProperty(PROXY_REALM);
    }

    public String getContentType() {
        String contentType = this.getProperty(CONTENT_TYPE);
        if (contentType == null) {
            return CONTENTTYPE_UTF8;
        }
        return contentType;
    }

    public void setContentType(String contentType) {
        this.setProperty(CONTENT_TYPE, contentType);
    }

    public String getHostName() {
        String connUrl = this.getConnectionString();
        return URI.create(connUrl).getHost();
    }

    public int getPort() {
        String connUrl = this.getConnectionString();
        return URI.create(connUrl).getPort();
    }

    public String getScheme() {
        String connUrl = this.getConnectionString();
        return URI.create(connUrl).getScheme();
    }

    public void setIsAdminServer(boolean isAdminServer) {
        this.setProperty(IS_ADMIN_SERVER, String.valueOf(isAdminServer));
    }

    public boolean isAdminServer() {
        return "true".equals(this.getProperty(IS_ADMIN_SERVER));
    }

    public void setPingService(String pingService) {
        this.setProperty(PING_SERVICE, pingService);
    }

    public String getPingService() {
        String service = this.getProperty(PING_SERVICE);
        if (service == null || service.length() == 0) {
            service = this.isAdminServer() ? "?IdcService=GET_ROOT_IDC_ADMIN_PAGE&IsJava=1" : "?IdcService=PING_SERVER&IsJava=1";
        }
        return service;
    }

    public void setSecurityRealm(String securityRealm) {
        this.setProperty(SECURITY_REALM, securityRealm);
    }

    public String getSecurityRealm() {
        String securityRealm = this.getProperty(SECURITY_REALM);
        if (securityRealm == null) {
            return DEFAULT_SECURITY_REALM;
        }
        return securityRealm;
    }
}

