/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.http.impl.RIDCHttpPartImpl;
import oracle.stellent.ridc.common.http.utils.RIDCHttpClientUtils;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.CaseInsensitiveKeyHashMap;
import oracle.stellent.ridc.common.util.NameValuePair;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.filter.IdcFilterManager;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.model.impl.DataFactoryImpl;
import oracle.stellent.ridc.model.serialize.HdaBinderSerializer;
import oracle.stellent.ridc.model.serialize.HdaSerializerUtils;
import oracle.stellent.ridc.protocol.Protocol;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.ServiceResponse;
import oracle.stellent.ridc.protocol.http.AuthenticationHandler;
import oracle.stellent.ridc.protocol.http.HttpProtocolException;
import oracle.stellent.ridc.protocol.http.IdcHttpClient;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConnection;
import oracle.stellent.ridc.protocol.http.auth.AuthenticationDetector;
import oracle.stellent.ridc.protocol.http.auth.BasicAuthHandler;
import oracle.stellent.ridc.protocol.http.auth.FormAuthHandler;
import oracle.stellent.ridc.protocol.http.auth.OAM11GWebgateAuthHandler;
import oracle.stellent.ridc.protocol.http.auth.OAMSSOAuthHandler;
import oracle.stellent.ridc.protocol.http.auth.OIMSSOAuthHandler;

public class IdcHttpProtocol
implements Protocol {
    public static final String IDC_VERSION = "IdcVersion";
    public static final String IDC_HTTP_METHOD = "ridc:http-method";
    private static volatile Map<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> s_handlers = new LinkedHashMap<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>>();
    private static final Object s_Synchronizer = new Object();
    private ILog m_log = LogFactory.getLog(this.getClass());
    private final IdcHttpClient m_client;
    private IdcFilterManager m_filterManager = null;
    private InputStream m_inputStream = null;
    private DataFactory m_dataFactory = null;
    private final IdcHttpClientConfig m_clientConfig;
    private ServiceRequest<IdcHttpClientConnection> m_serviceRequest = null;
    private AuthenticationHandler m_authHandler = null;

    private static Map<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> copyHandlers() {
        return new LinkedHashMap<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>>(s_handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHandler(IdcContext.HttpAuthScheme authScheme, Class<? extends AuthenticationHandler> handler) {
        Object object = s_Synchronizer;
        synchronized (object) {
            Map<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> copy = IdcHttpProtocol.copyHandlers();
            copy.put(authScheme, handler);
            s_handlers = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHandlerFirst(IdcContext.HttpAuthScheme authScheme, Class<? extends AuthenticationHandler> handler) {
        Object object = s_Synchronizer;
        synchronized (object) {
            LinkedHashMap<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> replacement = new LinkedHashMap<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>>();
            replacement.put(authScheme, handler);
            for (Map.Entry<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> entry : s_handlers.entrySet()) {
                if (entry.getKey().equals((Object)authScheme)) continue;
                replacement.put(entry.getKey(), entry.getValue());
            }
            s_handlers = replacement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHandlerLast(IdcContext.HttpAuthScheme authScheme, Class<? extends AuthenticationHandler> handler) {
        Object object = s_Synchronizer;
        synchronized (object) {
            LinkedHashMap<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> replacement = new LinkedHashMap<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>>();
            for (Map.Entry<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> entry : s_handlers.entrySet()) {
                if (entry.getKey().equals((Object)authScheme)) continue;
                replacement.put(entry.getKey(), entry.getValue());
            }
            replacement.put(authScheme, handler);
            s_handlers = replacement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<? extends AuthenticationHandler> removeHandler(IdcContext.HttpAuthScheme authScheme) {
        Class<? extends AuthenticationHandler> existing = null;
        Object object = s_Synchronizer;
        synchronized (object) {
            Map<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> copy = IdcHttpProtocol.copyHandlers();
            if (copy.containsKey((Object)authScheme)) {
                existing = copy.remove((Object)authScheme);
                s_handlers = copy;
            }
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllHandlers() {
        Object object = s_Synchronizer;
        synchronized (object) {
            Map<IdcContext.HttpAuthScheme, Class<? extends AuthenticationHandler>> copy = IdcHttpProtocol.copyHandlers();
            copy.clear();
            s_handlers = copy;
        }
    }

    public static Set<IdcContext.HttpAuthScheme> getAuthSchemes() {
        return s_handlers.keySet();
    }

    public static AuthenticationHandler createAuthHandler(IdcContext.HttpAuthScheme authScheme, IdcHttpProtocol httpProtocol) throws ProtocolException {
        Class<? extends AuthenticationHandler> authClass = s_handlers.get((Object)authScheme);
        if (authClass != null) {
            try {
                return authClass.getConstructor(IdcHttpProtocol.class).newInstance(httpProtocol);
            }
            catch (Exception exp) {
                throw new ProtocolException(RIDCMessages.protocol_error_constructing_auth_handler((Object)authScheme, authClass.getName()), (Throwable)exp);
            }
        }
        return null;
    }

    public IdcHttpProtocol(IdcHttpClient client, ServiceRequest<IdcHttpClientConnection> serviceRequest) {
        this.m_client = client;
        this.m_serviceRequest = serviceRequest;
        this.m_dataFactory = client.getDataFactory();
        this.m_clientConfig = (IdcHttpClientConfig)client.getConfig();
    }

    @Override
    public IdcHttpClient getClient() {
        return this.m_client;
    }

    public DataFactory getDataFactory() {
        if (this.m_dataFactory == null) {
            this.m_dataFactory = new DataFactoryImpl();
        }
        return this.m_dataFactory;
    }

    public ServiceRequest<IdcHttpClientConnection> getServiceRequest() {
        return this.m_serviceRequest;
    }

    public String getEncoding() {
        return this.getServiceRequest().getUserContext().getEncoding();
    }

    public IdcHttpClientConfig getClientConfig() {
        return this.m_clientConfig;
    }

    public IdcHttpClientConnection getConnection() {
        return this.getServiceRequest().getConnection();
    }

    public RIDCHttpClient getHttpClient() {
        return this.getConnection().getHttpClient();
    }

    public RIDCHttpMethod getHttpMethod() {
        return this.getConnection().getMethod();
    }

    public InputStream getInputStream() throws IOException, ProtocolException {
        if (this.m_inputStream == null) {
            this.m_inputStream = this.getHttpMethod().getResponseBodyAsStream();
            if (!this.m_inputStream.markSupported()) {
                this.m_inputStream = new BufferedInputStream(this.m_inputStream);
            }
        }
        return this.m_inputStream;
    }

    @Override
    public void setFilterManager(IdcFilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    @Override
    public IdcFilterManager getFilterManager() {
        return this.m_filterManager;
    }

    @Override
    public void writeRequest() throws ProtocolException {
        if (!"anonymous".equals(this.m_serviceRequest.getUserContext().getUser()) && this.m_serviceRequest.getUserContext().hasCredentials() && this.m_authHandler == null) {
            IdcContext.HttpAuthScheme authScheme = this.m_serviceRequest.getUserContext().getAuthScheme();
            if (authScheme != null) {
                this.m_authHandler = IdcHttpProtocol.createAuthHandler(authScheme, this);
            }
            if (this.m_authHandler == null) {
                this.m_authHandler = new AuthenticationDetector().determineAuthHandler(this);
                if (this.m_authHandler != null) {
                    this.m_serviceRequest.getUserContext().setAuthScheme(this.m_authHandler.getAuthScheme());
                }
            }
        }
        int status = 0;
        status = this.m_authHandler != null ? this.m_authHandler.sendAuthenticatedRequest() : this.sendRequest();
        String validHttpCodes = this.getServiceRequest().getDataBinder().getLocal("ridc:valid-http-codes");
        boolean valid = false;
        if (!StringTools.isEmpty(validHttpCodes)) {
            valid = StringTools.getListFromCsv(validHttpCodes).contains(String.valueOf(status));
        } else {
            boolean bl = valid = status == 200 || status == 301 || status == 502 || status == 503;
        }
        if (!valid && status >= 400 && status < 600) {
            try {
                valid = HdaSerializerUtils.determineFormat(this.getInputStream(), this.getEncoding()) == HdaSerializerUtils.FormatType.HDA_TYPE;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!valid) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            try {
                List<RIDCHttpHeader> headers = this.getConnection().getMethod().getResponseHeaders();
                for (RIDCHttpHeader header : headers) {
                    headerMap.put(header.getName(), header.getValue());
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            String msg = String.valueOf(status);
            String statusLine = this.getConnection().getMethod().getStatusLine();
            if (statusLine != null) {
                msg = statusLine.toString();
            }
            this.m_serviceRequest.getServiceLog().logExceptionResponse(String.format("'%s': %s %s", msg, status, headerMap));
            throw new HttpProtocolException(RIDCMessages.protocol_http_status_line(msg), status, headerMap);
        }
    }

    @Override
    public ServiceResponse readResponse() throws ProtocolException {
        HdaSerializerUtils.FormatType formatType = HdaSerializerUtils.FormatType.UNKNOWN_TYPE;
        ServiceResponse response = null;
        CaseInsensitiveKeyHashMap<String> headerMap = new CaseInsensitiveKeyHashMap<String>();
        List<RIDCHttpHeader> headers = this.getConnection().getMethod().getResponseHeaders();
        for (RIDCHttpHeader header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        String statusLine = this.getConnection().getMethod().getStatusLine();
        if (statusLine != null) {
            headerMap.put("", statusLine.toString());
        }
        boolean done = false;
        try {
            while (!done) {
                switch (formatType) {
                    case HDA_TYPE: {
                        response = new ServiceResponse(this.getDataFactory(), this.getEncoding(), headerMap, this.getInputStream(), ServiceResponse.ResponseType.BINDER);
                        done = true;
                        break;
                    }
                    case STREAM_TYPE: {
                        long contentLength;
                        if (headerMap.containsKey("Content-Disposition") && (contentLength = HdaSerializerUtils.readIdcContentLength(this.getInputStream())) != -1L) {
                            headerMap.put("Content-Length", String.valueOf(contentLength));
                            headerMap.put("idc-file", String.valueOf(contentLength));
                        }
                        response = new ServiceResponse(this.getDataFactory(), this.getEncoding(), headerMap, this.getInputStream(), ServiceResponse.ResponseType.STREAM);
                        done = true;
                        break;
                    }
                    default: {
                        formatType = HdaSerializerUtils.determineFormat(this.getInputStream(), this.getEncoding());
                    }
                }
                if (response == null) continue;
                response.setServiceLog(this.m_serviceRequest.getServiceLog());
            }
        }
        catch (IOException exp) {
            throw new ProtocolException(exp);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() throws ProtocolException {
        if (this.getConnection().getMethod() != null) {
            this.getConnection().getMethod().releaseConnection();
        }
        ServiceRequest<IdcHttpClientConnection> serviceRequest = this.getServiceRequest();
        List<NameValuePair> parameters = this.getDefaultParameters(serviceRequest);
        ServiceResponse response = null;
        try {
            this.executeBinderMethod(serviceRequest, parameters);
            response = this.readResponse();
            if (response.getResponseType().equals((Object)ServiceResponse.ResponseType.BINDER)) {
                response.getResponseAsBinder(false);
            }
        }
        catch (IOException ignore) {
        }
        catch (IdcClientException ignore) {
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public int sendRequest() throws ProtocolException {
        if (this.getConnection().getMethod() != null) {
            this.getConnection().getMethod().releaseConnection();
        }
        ServiceRequest<IdcHttpClientConnection> serviceRequest = this.getServiceRequest();
        DataBinder binder = serviceRequest.getDataBinder();
        List<NameValuePair> parameters = this.getDefaultParameters(serviceRequest);
        int status = 0;
        try {
            status = binder.containsFiles() ? this.executeStreamMethod(this.getServiceRequest(), parameters) : this.executeBinderMethod(this.getServiceRequest(), parameters);
        }
        catch (IOException exp) {
            this.m_serviceRequest.getServiceLog().logExceptionResponse(exp.getMessage());
            throw new ProtocolException(exp);
        }
        return status;
    }

    protected void addStringToBinder(String searchString, String htmlBody, DataBinder binder) {
        String matchedString;
        Pattern regEx = Pattern.compile(searchString + "=(.*)");
        Matcher matcher = regEx.matcher(htmlBody);
        if (matcher.matches() && (matchedString = matcher.group(1)) != null) {
            binder.putLocal(searchString, matchedString);
        }
    }

    protected List<NameValuePair> getDefaultParameters(ServiceRequest<?> serviceRequest) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add(new NameValuePair("IsJava", "1"));
        parameters.add(new NameValuePair("IdcService", serviceRequest.getService()));
        parameters.add(new NameValuePair("ClientEncoding", this.getEncoding()));
        return parameters;
    }

    protected int executeStreamMethod(ServiceRequest<?> serviceRequest, List<NameValuePair> parameters) throws IOException, ProtocolException {
        DataBinder binder = serviceRequest.getDataBinder();
        RIDCHttpPostMethod postMethod = this.getHttpClient().getPostMethod(this.getClientConfig().getConnectionString());
        postMethod.setServiceLog(serviceRequest.getServiceLog());
        this.getConnection().setMethod(postMethod);
        this.addRequestData(serviceRequest.getDataBinder(), postMethod);
        ArrayList multipartParts = new ArrayList();
        for (NameValuePair nameValuePair : parameters) {
            if (binder.getLocalData().containsKey(nameValuePair.getName())) continue;
            multipartParts.add(new RIDCHttpPartImpl<String>(nameValuePair.getName(), nameValuePair.getValue()));
        }
        for (String name : serviceRequest.getDataBinder().getLocalData().keySet()) {
            String value = serviceRequest.getDataBinder().getLocal(name);
            multipartParts.add(new RIDCHttpPartImpl<String>(name, value, this.getEncoding()));
        }
        if (binder.containsFiles()) {
            for (String name : binder.getFileNames()) {
                TransferFile transferFile = binder.getFile(name);
                multipartParts.add(new RIDCHttpPartImpl<TransferFile>(name, transferFile, this.getEncoding()));
            }
        }
        postMethod.setRequestEntity(multipartParts, this.getEncoding());
        return this.execute(postMethod);
    }

    protected int executeBinderMethod(ServiceRequest<?> serviceRequest, List<NameValuePair> parameters) throws IOException, ProtocolException {
        DataBinder binder = serviceRequest.getDataBinder();
        RIDCHttpMethod httpMethod = null;
        if (!binder.getLocalData().getBoolean("IsJava", true) || "GET".equalsIgnoreCase((String)binder.getLocalData().remove(IDC_HTTP_METHOD))) {
            httpMethod = this.getHttpClient().getGetMethod(this.getClientConfig().getConnectionString());
            httpMethod.setServiceLog(serviceRequest.getServiceLog());
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            for (NameValuePair pair : parameters) {
                if (binder.getLocalData().containsKey(pair.getName())) continue;
                params.add(pair);
            }
            for (String name : binder.getLocalData().keySet()) {
                String value = binder.getLocal(name);
                if (value == null) continue;
                params.add(new NameValuePair(name, value));
            }
            if (!binder.getResultSetNames().isEmpty()) {
                this.m_log.log(RIDCMessages.protocol_execute_unable_to_set_isjava(binder.getResultSetNames()), ILog.Level.WARN);
            }
            httpMethod.setQueryString(params);
        } else {
            httpMethod = this.getHttpClient().getPostMethod(this.getClientConfig().getConnectionString());
            httpMethod.setServiceLog(serviceRequest.getServiceLog());
            StringWriter sw = new StringWriter();
            StringBuffer sb = sw.getBuffer();
            sb.append("IsJava=1\r\n");
            sb.append("<?hda jcharset=");
            sb.append(this.getEncoding());
            sb.append("?>\r\n");
            HdaBinderSerializer serializer = new HdaBinderSerializer(this.getEncoding(), this.getDataFactory());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            serializer.serializeBinder(bout, binder);
            sw.getBuffer().append(bout.toString(this.getEncoding()));
            ((RIDCHttpPostMethod)httpMethod).setRequestEntity(sw.toString(), "text/hda", this.getEncoding());
        }
        this.getConnection().setMethod(httpMethod);
        this.addRequestData(binder, httpMethod);
        return this.execute(httpMethod);
    }

    private int execute(RIDCHttpMethod httpMethod) throws ProtocolException, IOException {
        int status = httpMethod.execute();
        if (httpMethod.getResponseHeader("Set-Cookie") != null) {
            HashMap<String, RIDCCookie> cookies = new HashMap<String, RIDCCookie>();
            for (RIDCCookie cookie : this.getHttpClient().getCookies()) {
                cookies.put(cookie.getName(), cookie);
            }
            IdcContext context = this.getServiceRequest().getUserContext();
            context.setCookies(cookies);
        }
        return status;
    }

    protected void addRequestData(DataBinder binder, RIDCHttpMethod httpMethod) {
        if (binder != null) {
            DataObject localData = binder.getLocalData();
            for (String name : localData.keySet()) {
                if (StringTools.isEmpty(name) || !name.startsWith("IdcHeader:")) continue;
                String headerValue = (String)localData.get(name);
                String headerName = name.substring("IdcHeader:".length());
                httpMethod.setRequestHeader(headerName, headerValue);
            }
        }
        RIDCHttpClientUtils.addRequestData(this.getServiceRequest().getUserContext(), this.getConnection().getHttpClient(), httpMethod, true);
    }

    static {
        s_handlers.put(IdcContext.HttpAuthScheme.OIM_SSO, OIMSSOAuthHandler.class);
        s_handlers.put(IdcContext.HttpAuthScheme.OAM_SSO, OAMSSOAuthHandler.class);
        s_handlers.put(IdcContext.HttpAuthScheme.OAM_11G_WG, OAM11GWebgateAuthHandler.class);
        s_handlers.put(IdcContext.HttpAuthScheme.LoginForm, FormAuthHandler.class);
        s_handlers.put(IdcContext.HttpAuthScheme.BasicAuth, BasicAuthHandler.class);
    }
}

