/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache3.impl;

import java.util.List;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3GetMethod;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3PostMethod;
import oracle.stellent.ridc.protocol.http.apache3.utils.AllCookieSpec;
import oracle.stellent.ridc.protocol.http.apache3.utils.Apache3Utils;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.params.HttpClientParams;

public class HttpApache3Client
implements RIDCHttpClient {
    private HttpClient httpClient = new HttpClient();

    public HttpApache3Client(boolean multithreaded) {
        HttpClientParams params = this.httpClient.getParams();
        params.setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
        if (multithreaded) {
            MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
            manager.getParams().setStaleCheckingEnabled(true);
            this.httpClient.setHttpConnectionManager((HttpConnectionManager)manager);
        }
    }

    @Override
    public void clear() {
        this.httpClient.getParams().clear();
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.httpClient.getParams().setSoTimeout(socketTimeout);
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyRealm) {
        this.httpClient.getHostConfiguration().setProxy(proxyHost, proxyPort);
        UsernamePasswordCredentials creds = null;
        if (!StringTools.isEmpty(proxyUsername)) {
            creds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
        }
        this.httpClient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)creds);
    }

    @Override
    public void setCredentials(String any, oracle.stellent.ridc.auth.Credentials idcCredentials) {
        Credentials credentials = Apache3Utils.getCredentials(idcCredentials);
        this.httpClient.getState().setCredentials(AuthScope.ANY, credentials);
    }

    @Override
    public void setAuthenticationPreemptive(boolean preemptive) {
        this.httpClient.getParams().setAuthenticationPreemptive(preemptive);
    }

    @Override
    public List<RIDCCookie> getCookies() {
        Cookie[] cookies = this.httpClient.getState().getCookies();
        return Apache3Utils.convert(cookies);
    }

    @Override
    public void addCookie(RIDCCookie cookie) {
        Cookie apacheCookie = new Cookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getMaxAge(), cookie.isSecure());
        this.httpClient.getState().addCookie(apacheCookie);
    }

    @Override
    public void resetState() {
        this.httpClient.setState(new HttpState());
    }

    @Override
    public HttpApache3GetMethod getGetMethod(String url) {
        return new HttpApache3GetMethod(url, this);
    }

    @Override
    public HttpApache3PostMethod getPostMethod(String url) {
        return new HttpApache3PostMethod(url, this);
    }

    public HttpClient getDelegateObject() {
        return this.httpClient;
    }

    static {
        CookiePolicy.registerCookieSpec((String)"idcAllCookies", AllCookieSpec.class);
    }
}

