/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache3.impl;

import java.net.URISyntaxException;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3Client;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3Method;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.methods.GetMethod;

public class HttpApache3GetMethod
extends HttpApache3Method<GetMethod>
implements RIDCHttpGetMethod {
    private ILog m_log = LogFactory.getLog(HttpApache3GetMethod.class);

    public HttpApache3GetMethod(String url, HttpApache3Client httpApache3Client) {
        this.apacheMethod = new GetMethod(url);
        this.ridcClient = httpApache3Client;
    }

    @Override
    protected void logRequest(String logID, GetMethod method) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("GET ");
            try {
                sb.append(this.getURI());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (Header h : method.getRequestHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }
}

