/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache3.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.List;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.impl.RIDCHttpHeaderImpl;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.NameValuePair;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3Client;
import oracle.stellent.ridc.protocol.http.apache3.utils.Apache3Utils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.PostMethod;

public abstract class HttpApache3Method<M extends HttpMethodBase>
implements RIDCHttpMethod {
    protected M apacheMethod = null;
    protected HttpApache3Client ridcClient;
    protected ServiceLog serviceLog;
    private ILog m_log = LogFactory.getLog(HttpApache3Method.class);

    @Override
    public void releaseConnection() {
        this.apacheMethod.releaseConnection();
    }

    public M getDelegateObject() {
        return this.apacheMethod;
    }

    @Override
    public int getStatusCode() {
        return this.apacheMethod.getStatusCode();
    }

    @Override
    public java.net.URI getURI() throws URISyntaxException {
        try {
            URI uri = this.apacheMethod.getURI();
            return new java.net.URI(uri.toString());
        }
        catch (URIException e) {
            throw new IllegalArgumentException("Invalid uri - " + e.getMessage());
        }
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return this.apacheMethod.getResponseBodyAsStream();
    }

    @Override
    public void setRequestHeader(String headerName, String headerValue) {
        this.apacheMethod.setRequestHeader(headerName, headerValue);
    }

    @Override
    public RIDCHttpHeader getResponseHeader(String headerName) {
        Header responseHeader = this.apacheMethod.getResponseHeader(headerName);
        if (responseHeader != null) {
            return new RIDCHttpHeaderImpl(responseHeader.getName(), responseHeader.getValue());
        }
        return null;
    }

    @Override
    public void setQueryString(List<NameValuePair> params) {
        this.apacheMethod.setQueryString(Apache3Utils.convert(params));
    }

    @Override
    public List<RIDCHttpHeader> getResponseHeaders() {
        Header[] responseHeaders = this.apacheMethod.getResponseHeaders();
        return Apache3Utils.convertToRIDCHeaders(responseHeaders);
    }

    @Override
    public String getStatusLine() {
        StatusLine statusLine = this.apacheMethod.getStatusLine();
        return statusLine.toString();
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.apacheMethod.setFollowRedirects(followRedirects);
    }

    @Override
    public void addRequestHeader(String name, String value) {
        this.apacheMethod.addRequestHeader(name, value);
    }

    @Override
    public void setCookiePolicy(String cookiePolicy) {
        this.apacheMethod.getParams().setCookiePolicy(cookiePolicy);
    }

    @Override
    public void setParameter(String param, String value) {
        this.apacheMethod.getParams().setParameter(param, (Object)value);
    }

    @Override
    public RIDCHttpClient getRidcClient() {
        return this.ridcClient;
    }

    @Override
    public int execute() throws IOException {
        String logID = this.serviceLog != null ? this.serviceLog.getLogId() : ServiceLog.toId(System.nanoTime());
        this.logRequest(logID, this.apacheMethod);
        HttpClient httpClient = (HttpClient)this.getRidcClient().getDelegateObject();
        int status = httpClient.executeMethod(this.apacheMethod);
        this.logResponse(logID, this.apacheMethod);
        return status;
    }

    @Override
    public void setServiceLog(ServiceLog serviceLog) {
        this.serviceLog = serviceLog;
    }

    protected void logRequest(String logID, M method) {
    }

    protected void logResponse(String logID, M method) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            String m = method instanceof PostMethod ? "POST " : "GET ";
            sb.append(m).append("response status: ").append(this.getStatusCode());
            sb.append(" ").append(this.getStatusLine()).append("\n");
            try {
                sb.append("URI: ").append(this.getURI()).append("\n");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Response headers: \n");
            for (RIDCHttpHeader h : this.getResponseHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[<-]%s [RESPONSE]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }
}

