/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache3.impl;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3Client;
import oracle.stellent.ridc.protocol.http.apache3.impl.HttpApache3Method;
import oracle.stellent.ridc.protocol.http.apache3.obj.HdaFilePart;
import oracle.stellent.ridc.protocol.http.apache3.obj.HdaStringPart;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class HttpApache3PostMethod
extends HttpApache3Method<PostMethod>
implements RIDCHttpPostMethod {
    private ILog m_log = LogFactory.getLog(HttpApache3PostMethod.class);

    public HttpApache3PostMethod(String url, HttpApache3Client httpApache3Client) {
        this.ridcClient = httpApache3Client;
        this.apacheMethod = new PostMethod(url);
    }

    @Override
    public void addParameter(String paramName, String paramValue) {
        ((PostMethod)this.apacheMethod).addParameter(paramName, paramValue);
    }

    public void setParameter(String parameterName, Object parameterValue) {
        ((PostMethod)this.apacheMethod).setParameter(parameterName, (String)parameterValue);
    }

    @Override
    public void setRequestEntity(String content, String contentType, String encoding) throws UnsupportedEncodingException {
        ((PostMethod)this.apacheMethod).setRequestEntity((RequestEntity)new StringRequestEntity(content, contentType, encoding));
    }

    @Override
    public void setRequestEntity(List<RIDCHttpPart<?>> multipartParts, String encoding) {
        ArrayList<Object> apachePart = new ArrayList<Object>();
        for (RIDCHttpPart<?> p : multipartParts) {
            if (RIDCHttpPart.PartType.STRING == p.getType()) {
                apachePart.add((Object)new HdaStringPart(p.getName(), (String)p.getContent(), p.getEncoding()));
                continue;
            }
            if (RIDCHttpPart.PartType.TRANSFERFILE != p.getType()) continue;
            apachePart.add((Object)new HdaFilePart(p.getName(), (TransferFile)p.getContent(), p.getEncoding()));
        }
        ((PostMethod)this.apacheMethod).setRequestEntity((RequestEntity)new MultipartRequestEntity(apachePart.toArray(new Part[0]), ((PostMethod)this.apacheMethod).getParams()));
    }

    @Override
    public void addLoginFormCredentials(IdcContext.LoginForm loginForm, Credentials.BasicCredentials credentials) {
        this.addParameter(loginForm.getUsernameField(), credentials.getUserName());
        this.addParameter(loginForm.getPasswordField(), credentials.getPassword());
    }

    @Override
    protected void logRequest(String logID, PostMethod method) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("POST ");
            try {
                sb.append(this.getURI());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (Header h : method.getRequestHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            RequestEntity entity = method.getRequestEntity();
            if (entity != null) {
                if (entity instanceof MultipartRequestEntity) {
                    MultipartRequestEntity mp = (MultipartRequestEntity)entity;
                    this.m_log.log(String.format("[->]%s [MULTIPART REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
                } else if (entity instanceof StringRequestEntity) {
                    sb.append("Request data: \n");
                    StringRequestEntity data = (StringRequestEntity)entity;
                    sb.append(data.getContent()).append("\n");
                    this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
                } else if (entity instanceof ByteArrayRequestEntity) {
                    sb.append("Request form data: \n");
                    for (NameValuePair p : method.getParameters()) {
                        sb.append("  ").append(p.getName()).append(": ");
                        sb.append(p.getName() != null && p.getName().trim().toLowerCase().endsWith("password") ? "########" : p.getValue());
                        sb.append("\n");
                    }
                    this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
                }
            } else {
                this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
            }
        }
    }
}

