/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache3.obj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.TransferFile;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.util.EncodingUtil;

public class HdaFilePart
extends FilePart {
    private static final byte[] FILE_NAME_BYTES = EncodingUtil.getAsciiBytes((String)"; filename=");
    private TransferFile m_fileInfo = null;

    public HdaFilePart(String name, TransferFile fileInfo, String charset) {
        super(name, (PartSource)new TransferFilePartSource(fileInfo), null, charset);
        this.m_fileInfo = fileInfo;
    }

    public HdaFilePart(String name, TransferFile fileInfo) {
        super(name, (PartSource)new TransferFilePartSource(fileInfo));
    }

    public String getTransferEncoding() {
        return null;
    }

    protected void sendDispositionHeader(OutputStream out) throws IOException {
        if (this.m_fileInfo == null || this.m_fileInfo.getFileName() == null) {
            super.sendDispositionHeader(out);
        } else {
            out.write(CONTENT_DISPOSITION_BYTES);
            out.write(QUOTE_BYTES);
            out.write(EncodingUtil.getAsciiBytes((String)this.getName()));
            out.write(QUOTE_BYTES);
            String filename = this.m_fileInfo.getFileName();
            if (filename != null) {
                out.write(FILE_NAME_BYTES);
                out.write(QUOTE_BYTES);
                out.write(HdaFilePart.getCharsetBytes(filename, this.getCharSet()));
                out.write(QUOTE_BYTES);
            }
        }
    }

    public static byte[] getCharsetBytes(String data, String charset) {
        if (data == null) {
            throw new IllegalArgumentException(RIDCMessages.protocol_null_parameter().toString());
        }
        if (charset == null || StringTools.isEmpty(charset.trim())) {
            charset = "UTF-8";
        }
        try {
            return data.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientError(RIDCMessages.protocol_requires_support(charset).toString());
        }
    }

    protected static class TransferFilePartSource
    implements PartSource {
        protected TransferFile m_transferFile = null;

        public TransferFilePartSource(TransferFile transferFile) {
            this.m_transferFile = transferFile;
        }

        public long getLength() {
            return this.m_transferFile.getContentLength();
        }

        public String getFileName() {
            return this.m_transferFile.getFileName();
        }

        public InputStream createInputStream() throws IOException {
            return this.m_transferFile.getInputStream();
        }
    }
}

