/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache3.utils;

import java.util.ArrayList;
import java.util.List;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.impl.RIDCHttpHeaderImpl;
import oracle.stellent.ridc.common.util.NameValuePair;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.UsernamePasswordCredentials;

public class Apache3Utils {
    public static List<RIDCHttpHeader> convertToRIDCHeaders(Header[] apacheHeaders) {
        ArrayList<RIDCHttpHeader> headers = new ArrayList<RIDCHttpHeader>();
        for (Header h : apacheHeaders) {
            headers.add(new RIDCHttpHeaderImpl(h.getName(), h.getValue()));
        }
        return headers;
    }

    public static Credentials getCredentials(oracle.stellent.ridc.auth.Credentials idcCredentials) {
        UsernamePasswordCredentials credentials = null;
        if (idcCredentials != null) {
            Object ridcCredentials;
            if (idcCredentials instanceof Credentials.BasicCredentials) {
                Credentials.BasicCredentials basicCreds = (Credentials.BasicCredentials)idcCredentials;
                credentials = new UsernamePasswordCredentials(basicCreds.getUserName(), basicCreds.getPassword());
            } else if (idcCredentials instanceof Credentials.UserNameOnlyCredentials) {
                Credentials.UserNameOnlyCredentials userCreds = (Credentials.UserNameOnlyCredentials)idcCredentials;
                credentials = new UsernamePasswordCredentials(userCreds.getUserName());
            } else if (idcCredentials instanceof Credentials.HttpClientCredentials && (ridcCredentials = ((Credentials.HttpClientCredentials)idcCredentials).getCredentials()) instanceof Credentials) {
                credentials = (Credentials)ridcCredentials;
            }
        }
        return credentials;
    }

    public static List<RIDCCookie> convert(Cookie[] cookies) {
        ArrayList<RIDCCookie> ridcCookies = new ArrayList<RIDCCookie>();
        for (Cookie c : cookies) {
            ridcCookies.add(new RIDCCookie(c.getDomain(), c.getName(), c.getValue(), c.getPath(), -1, c.getSecure()));
        }
        return ridcCookies;
    }

    public static org.apache.commons.httpclient.NameValuePair[] convert(List<NameValuePair> params) {
        ArrayList<org.apache.commons.httpclient.NameValuePair> nvPairs = new ArrayList<org.apache.commons.httpclient.NameValuePair>();
        for (NameValuePair p : params) {
            nvPairs.add(new org.apache.commons.httpclient.NameValuePair(p.getName(), p.getValue()));
        }
        return nvPairs.toArray(new org.apache.commons.httpclient.NameValuePair[params.size()]);
    }
}

