/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache4.impl;

import java.io.IOException;
import java.util.List;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.protocol.http.apache4.impl.Apache4CookieSpecFactory;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4GetMethod;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4PostMethod;
import oracle.stellent.ridc.protocol.http.apache4.utils.Apache4Utils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpApache4Client
implements RIDCHttpClient {
    DefaultHttpClient client = new DefaultHttpClient();
    HttpRequestInterceptor preemptiveAuthHandler = new HttpRequestInterceptor(){

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthScope authScope;
            org.apache.http.auth.Credentials creds;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                authState.setAuthScheme((AuthScheme)new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    };

    public HttpApache4Client() {
        this.client.getCookieSpecs().register("idcAllCookies", (CookieSpecFactory)new Apache4CookieSpecFactory());
    }

    @Override
    public void addCookie(RIDCCookie cookie) {
        BasicClientCookie aCookie = new BasicClientCookie(cookie.getName(), cookie.getValue());
        aCookie.setDomain(cookie.getDomain());
        aCookie.setPath(cookie.getPath());
        aCookie.setSecure(cookie.isSecure());
        this.client.getCookieStore().addCookie((Cookie)aCookie);
    }

    @Override
    public void clear() {
        this.client.setParams(null);
    }

    @Override
    public List<RIDCCookie> getCookies() {
        List aCookies = this.client.getCookieStore().getCookies();
        return Apache4Utils.convert(aCookies);
    }

    @Override
    public void resetState() {
        this.client = new DefaultHttpClient();
    }

    @Override
    public void setAuthenticationPreemptive(boolean authPremptive) {
        if (authPremptive) {
            this.client.addRequestInterceptor(this.preemptiveAuthHandler, 0);
        } else {
            this.client.removeRequestInterceptorByClass(this.preemptiveAuthHandler.getClass());
        }
    }

    @Override
    public void setCredentials(String scope, Credentials idcCredentials) {
        AuthScope authScope = null;
        if ("any".equalsIgnoreCase(scope)) {
            authScope = AuthScope.ANY;
        }
        org.apache.http.auth.Credentials apacheCredentials = Apache4Utils.convertCredentials(idcCredentials);
        this.client.getCredentialsProvider().setCredentials(authScope, apacheCredentials);
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyRealm) {
        HttpHost hcProxyHost = new HttpHost(proxyHost, proxyPort);
        if (!StringTools.isEmpty(proxyUsername)) {
            this.client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
        }
        this.client.getParams().setParameter("http.route.default-proxy", (Object)hcProxyHost);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.client.getParams(), (int)socketTimeout);
    }

    @Override
    public HttpApache4GetMethod getGetMethod(String url) {
        return new HttpApache4GetMethod(url, this);
    }

    @Override
    public HttpApache4PostMethod getPostMethod(String url) {
        return new HttpApache4PostMethod(url, this);
    }

    public DefaultHttpClient getDelegateObject() {
        return this.client;
    }
}

