/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache4.impl;

import java.net.URISyntaxException;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4Client;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4Method;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;

public class HttpApache4GetMethod
extends HttpApache4Method<HttpGet>
implements RIDCHttpGetMethod {
    private ILog m_log = LogFactory.getLog(HttpApache4GetMethod.class);

    public HttpApache4GetMethod(String url, HttpApache4Client httpApache4Client) {
        this.method = new HttpGet(url);
        this.httpClient = httpApache4Client;
    }

    @Override
    protected void logRequest(String logID, HttpGet method) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("GET ");
            try {
                sb.append(this.getURI());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (Header h : method.getAllHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }
}

