/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache4.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.impl.RIDCHttpHeaderImpl;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.HttpUtils;
import oracle.stellent.ridc.common.util.NameValuePair;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4Client;
import oracle.stellent.ridc.protocol.http.apache4.utils.Apache4Utils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public abstract class HttpApache4Method<M extends HttpRequestBase>
implements RIDCHttpMethod {
    protected M method = null;
    private HttpResponse response;
    private HttpContext context;
    protected HttpApache4Client httpClient;
    protected ServiceLog serviceLog;
    private ILog m_log = LogFactory.getLog(HttpApache4Method.class);

    @Override
    public void addRequestHeader(String name, String value) {
        this.method.addHeader(name, value);
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException {
        return this.response.getEntity().getContent();
    }

    @Override
    public RIDCHttpHeader getResponseHeader(String headerName) {
        Header[] headers = this.response.getHeaders(headerName);
        if (headers != null && headers.length > 0) {
            return new RIDCHttpHeaderImpl(headers[0].getName(), headers[0].getValue());
        }
        return null;
    }

    @Override
    public List<RIDCHttpHeader> getResponseHeaders() {
        Header[] allHeaders = this.response.getAllHeaders();
        return Apache4Utils.convertToRIDCHeaders(allHeaders);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getStatusLine() {
        return this.response.getStatusLine().toString();
    }

    @Override
    public URI getURI() throws URISyntaxException {
        if (this.context == null) {
            return this.method.getURI();
        }
        HttpUriRequest currentReq = (HttpUriRequest)this.context.getAttribute("http.request");
        HttpHost currentHost = (HttpHost)this.context.getAttribute("http.target_host");
        return currentReq.getURI().isAbsolute() ? currentReq.getURI() : new URI(currentHost.toURI()).resolve(currentReq.getURI());
    }

    @Override
    public void releaseConnection() {
        this.method.abort();
    }

    @Override
    public void setCookiePolicy(String cookiePolicy) {
        HttpClientParams.setCookiePolicy((HttpParams)this.method.getParams(), (String)cookiePolicy);
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        HttpParams httpParams = this.method.getParams();
        HttpClientParams.setRedirecting((HttpParams)httpParams, (boolean)followRedirects);
    }

    @Override
    public void setRequestHeader(String headerName, String headerValue) {
        this.method.setHeader(headerName, headerValue);
    }

    @Override
    public void setParameter(String param, String value) {
        this.method.getParams().setParameter(param, (Object)value);
    }

    @Override
    public void setQueryString(List<NameValuePair> nvpairList) {
        String formattedString = URLEncodedUtils.format(Apache4Utils.convertNVPair(nvpairList), (String)"UTF-8");
        URI uri = HttpUtils.replaceQueryString(this.method.getURI(), formattedString);
        this.method.setURI(uri);
    }

    @Override
    public RIDCHttpClient getRidcClient() {
        return this.httpClient;
    }

    @Override
    public int execute() throws IOException {
        String logID = this.serviceLog != null ? this.serviceLog.getLogId() : ServiceLog.toId(System.nanoTime());
        this.logRequest(logID, this.method);
        DefaultHttpClient client = (DefaultHttpClient)this.getRidcClient().getDelegateObject();
        this.context = new BasicHttpContext();
        this.response = client.execute(this.method, this.context);
        this.logResponse(logID, this.method, this.response);
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public void setServiceLog(ServiceLog serviceLog) {
        this.serviceLog = serviceLog;
    }

    protected void logRequest(String logID, M method) {
    }

    protected void logResponse(String logID, M method, HttpResponse httpResponse) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            String m = method instanceof HttpPost ? "POST " : "GET ";
            sb.append(m).append("response status: ").append(this.getStatusCode());
            sb.append(" ").append(this.getStatusLine()).append("\n");
            try {
                sb.append("URI: ").append(this.getURI()).append("\n");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Response headers: \n");
            for (RIDCHttpHeader h : this.getResponseHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[<-]%s [RESPONSE]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }
}

