/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache4.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4Client;
import oracle.stellent.ridc.protocol.http.apache4.impl.HttpApache4Method;
import oracle.stellent.ridc.protocol.http.apache4.obj.Apache4InputStreamBody;
import oracle.stellent.ridc.protocol.http.apache4.obj.Apache4StringBody;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.message.BasicNameValuePair;

public class HttpApache4PostMethod
extends HttpApache4Method<HttpPost>
implements RIDCHttpPostMethod {
    private ILog m_log = LogFactory.getLog(HttpApache4PostMethod.class);
    protected List<NameValuePair> m_formData = new ArrayList<NameValuePair>();

    public HttpApache4PostMethod(String url, HttpApache4Client httpApache4Client) {
        this.method = new HttpPost(url);
        this.httpClient = httpApache4Client;
    }

    @Override
    public void setRequestEntity(String content, String contentType, String encoding) throws UnsupportedEncodingException {
        StringEntity stringEntity = new StringEntity(content, encoding);
        ((HttpPost)this.method).setEntity((HttpEntity)stringEntity);
    }

    @Override
    public void setRequestEntity(List<RIDCHttpPart<?>> multipartParts, String encoding) throws IOException {
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName(encoding));
        for (RIDCHttpPart<?> p : multipartParts) {
            if (RIDCHttpPart.PartType.STRING == p.getType()) {
                Apache4StringBody stringBody = new Apache4StringBody((String)p.getContent(), Charset.forName(p.getEncoding()));
                multipartEntity.addPart(p.getName(), (ContentBody)stringBody);
                continue;
            }
            if (RIDCHttpPart.PartType.TRANSFERFILE != p.getType()) continue;
            TransferFile file = (TransferFile)p.getContent();
            Apache4InputStreamBody inputStreamBody = new Apache4InputStreamBody(file.getInputStream(), file.getContentType(), file.getFileName(), p.getEncoding());
            multipartEntity.addPart(p.getName(), (ContentBody)inputStreamBody);
        }
        ((HttpPost)this.method).setEntity((HttpEntity)multipartEntity);
    }

    @Override
    public void addParameter(String name, String value) {
        if (this.m_formData == null) {
            this.m_formData = new ArrayList<NameValuePair>();
        }
        this.m_formData.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    @Override
    public void addLoginFormCredentials(IdcContext.LoginForm loginForm, Credentials.BasicCredentials credentials) throws UnsupportedEncodingException {
        this.addParameter(loginForm.getUsernameField(), credentials.getUserName());
        this.addParameter(loginForm.getPasswordField(), credentials.getPassword());
    }

    @Override
    public int execute() throws IOException {
        if (this.m_formData != null && this.m_formData.size() > 0) {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(this.m_formData, "UTF-8");
            ((HttpPost)this.method).setEntity((HttpEntity)entity);
        }
        return super.execute();
    }

    @Override
    protected void logRequest(String logID, HttpPost method) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("POST ");
            try {
                sb.append(this.getURI());
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (Header h : method.getAllHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            HttpEntity entity = method.getEntity();
            if (entity != null) {
                if (entity instanceof MultipartEntity) {
                    MultipartEntity mp = (MultipartEntity)entity;
                    this.m_log.log(String.format("[->]%s [MULTIPART REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
                } else if (entity instanceof UrlEncodedFormEntity) {
                    sb.append("Request form data: \n");
                    for (NameValuePair p : this.m_formData) {
                        sb.append("  ").append(p.getName()).append(": ");
                        sb.append(p.getName() != null && p.getName().trim().toLowerCase().endsWith("password") ? "########" : p.getValue());
                        sb.append("\n");
                    }
                    this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
                } else if (entity instanceof StringEntity) {
                    sb.append("Request data: \n");
                    StringEntity data = (StringEntity)entity;
                    String contentType = data.getContentType().getValue();
                    String charset = "UTF-8";
                    int idx = contentType.indexOf("; charset=");
                    if (idx != -1) {
                        charset = contentType.substring(idx + "; charset=".length());
                    }
                    try {
                        InputStream is = data.getContent();
                        String content = StreamUtil.getStringFromStream(is, charset);
                        sb.append(content).append("\n");
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
                }
            } else {
                this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
            }
        }
    }
}

