/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.apache4.utils;

import java.util.ArrayList;
import java.util.List;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.impl.RIDCHttpHeaderImpl;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.cookie.Cookie;
import org.apache.http.message.BasicNameValuePair;

public class Apache4Utils {
    public static List<RIDCCookie> convert(List<Cookie> aCookies) {
        ArrayList<RIDCCookie> ridcCookies = new ArrayList<RIDCCookie>();
        for (Cookie c : aCookies) {
            ridcCookies.add(new RIDCCookie(c.getDomain(), c.getName(), c.getValue(), c.getPath(), -1, c.isSecure()));
        }
        return ridcCookies;
    }

    public static List<RIDCHttpHeader> convertToRIDCHeaders(Header[] allHeaders) {
        ArrayList<RIDCHttpHeader> headers = new ArrayList<RIDCHttpHeader>();
        for (Header h : allHeaders) {
            headers.add(new RIDCHttpHeaderImpl(h.getName(), h.getValue()));
        }
        return headers;
    }

    public static Credentials convertCredentials(oracle.stellent.ridc.auth.Credentials idcCredentials) {
        UsernamePasswordCredentials credentials = null;
        if (idcCredentials != null) {
            Object ridcCredentials;
            if (idcCredentials instanceof Credentials.BasicCredentials) {
                Credentials.BasicCredentials basicCreds = (Credentials.BasicCredentials)idcCredentials;
                credentials = new UsernamePasswordCredentials(basicCreds.getUserName(), basicCreds.getPassword());
            } else if (idcCredentials instanceof Credentials.UserNameOnlyCredentials) {
                Credentials.UserNameOnlyCredentials userCreds = (Credentials.UserNameOnlyCredentials)idcCredentials;
                credentials = new NTCredentials(userCreds.getUserName());
            } else if (idcCredentials instanceof Credentials.HttpClientCredentials && (ridcCredentials = ((Credentials.HttpClientCredentials)idcCredentials).getCredentials()) instanceof Credentials) {
                credentials = (Credentials)ridcCredentials;
            }
        }
        return credentials;
    }

    public static List<? extends NameValuePair> convertNVPair(List<oracle.stellent.ridc.common.util.NameValuePair> nvpairList) {
        ArrayList<BasicNameValuePair> apacheNVList = new ArrayList<BasicNameValuePair>();
        for (oracle.stellent.ridc.common.util.NameValuePair nv : nvpairList) {
            apacheNVList.add(new BasicNameValuePair(nv.getName(), nv.getValue()));
        }
        return apacheNVList;
    }
}

