/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.auth;

import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.http.utils.RIDCHttpClientUtils;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.i18n.locale.LocaleMessage;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.AuthenticationHandler;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;

public class AuthenticationDetector {
    private ILog m_log = LogFactory.getLog(this.getClass());

    public AuthenticationHandler determineAuthHandler(IdcHttpProtocol httpProtocol) throws ProtocolException {
        IdcHttpClientConfig clientConfig = httpProtocol.getClientConfig();
        RIDCHttpClient httpClient = null;
        try {
            httpClient = RIDCHttpClientUtils.createHttpClient(clientConfig, false);
        }
        catch (IdcClientException exp) {
            httpProtocol.getServiceRequest().getServiceLog().logExceptionResponse(exp.getMessage());
            throw new ProtocolException(exp);
        }
        String url = clientConfig.getConnectionString() + clientConfig.getPingService();
        RIDCHttpGetMethod pingMethod = httpClient.getGetMethod(url);
        pingMethod.setFollowRedirects(false);
        pingMethod.setServiceLog(httpProtocol.getServiceRequest().getServiceLog());
        RIDCHttpClientUtils.addRequestData(httpProtocol.getServiceRequest().getUserContext(), httpClient, pingMethod, false);
        String logId = httpProtocol.getServiceRequest().getServiceLog().getLogId();
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            LocaleMessage msg = RIDCMessages.protocol_auth_scheme_ping_server(clientConfig.getPingService());
            String text = String.format("[>>]%s %s", logId, msg.toString());
            String message = text.substring(0, msg.getMnemonicCharacterIndex()) + '&' + text.substring(msg.getMnemonicCharacterIndex(), text.length());
            this.m_log.log(message, ILog.Level.TRACE);
        }
        try {
            pingMethod.execute();
        }
        catch (Exception exp) {
            httpProtocol.getServiceRequest().getServiceLog().logExceptionResponse(exp.getMessage());
            throw new ProtocolException(exp);
        }
        finally {
            pingMethod.releaseConnection();
        }
        AuthenticationHandler authHandler = null;
        for (IdcContext.HttpAuthScheme scheme : IdcHttpProtocol.getAuthSchemes()) {
            AuthenticationHandler handler = IdcHttpProtocol.createAuthHandler(scheme, httpProtocol);
            if (handler == null) continue;
            String msg = String.format("[>>]%s %s", logId, RIDCMessages.protocol_auth_scheme_trying((Object)handler.getAuthScheme()));
            this.m_log.log(msg, ILog.Level.TRACE);
            if (!handler.isAuthSupported(httpClient, pingMethod)) continue;
            authHandler = handler;
            msg = String.format("[>>]%s %s", logId, RIDCMessages.protocol_auth_scheme_using((Object)handler.getAuthScheme()));
            this.m_log.log(msg, ILog.Level.DEBUG);
            break;
        }
        if (authHandler == null) {
            this.m_log.log(RIDCMessages.protocol_unable_to_locate_auth_handler(pingMethod.getStatusLine()), ILog.Level.WARN);
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
                this.m_log.log(RIDCMessages.protocol_ping_headers(RIDCHttpClientUtils.getResponseHeaders(pingMethod.getResponseHeaders())), ILog.Level.DEBUG);
            }
        }
        return authHandler;
    }
}

