/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.auth;

import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.http.AuthenticationHandler;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConnection;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;

public class BasicAuthHandler
implements AuthenticationHandler {
    private IdcHttpProtocol m_httpProtocol = null;

    public BasicAuthHandler(IdcHttpProtocol httpProtocol) {
        this.m_httpProtocol = httpProtocol;
    }

    public IdcHttpProtocol getHttpProtocol() {
        return this.m_httpProtocol;
    }

    @Override
    public boolean isAuthSupported(RIDCHttpClient httpClient, RIDCHttpMethod httpMethod) {
        int statusCode = -1;
        try {
            statusCode = httpMethod.getStatusCode();
        }
        catch (ProtocolException ignore) {
            // empty catch block
        }
        return statusCode == 401;
    }

    @Override
    public IdcContext.HttpAuthScheme getAuthScheme() {
        return IdcContext.HttpAuthScheme.BasicAuth;
    }

    @Override
    public int sendAuthenticatedRequest() throws ProtocolException {
        ServiceRequest<IdcHttpClientConnection> request = this.getHttpProtocol().getServiceRequest();
        Credentials idcCredentials = request.getUserContext().getCredentials();
        if (idcCredentials != null) {
            request.getConnection().getHttpClient().setCredentials("any", idcCredentials);
            if (request.getUserContext().getAuthScheme() == IdcContext.HttpAuthScheme.BasicAuth) {
                request.getConnection().getHttpClient().setAuthenticationPreemptive(true);
            }
        }
        return this.getHttpProtocol().sendRequest();
    }
}

