/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.auth;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.http.utils.RIDCHttpClientUtils;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.AuthenticationHandler;
import oracle.stellent.ridc.protocol.http.HttpProtocolException;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;

public class FormAuthHandler
implements AuthenticationHandler {
    private ILog m_log = LogFactory.getLog(this.getClass());
    private IdcHttpProtocol m_httpProtocol = null;
    private RIDCHttpClient m_httpClient = null;
    private RIDCHttpMethod m_pingMethod = null;

    public FormAuthHandler(IdcHttpProtocol httpProtocol) {
        this.m_httpProtocol = httpProtocol;
    }

    public IdcHttpProtocol getHttpProtocol() {
        return this.m_httpProtocol;
    }

    public RIDCHttpClient getHttpClient() throws ProtocolException {
        if (this.m_httpClient == null) {
            this.m_httpClient = this.createHttpClient();
        }
        return this.m_httpClient;
    }

    public void setHttpClient(RIDCHttpClient httpClient) {
        this.m_httpClient = httpClient;
    }

    public RIDCHttpMethod getPingMethod() {
        return this.m_pingMethod;
    }

    public void setPingMethod(RIDCHttpMethod pingMethod) {
        this.m_pingMethod = pingMethod;
    }

    @Override
    public boolean isAuthSupported(RIDCHttpClient httpClient, RIDCHttpMethod httpMethod) throws ProtocolException {
        this.setHttpClient(httpClient);
        this.setPingMethod(httpMethod);
        return RIDCHttpClientUtils.isRedirectStatus(this.getPingMethod().getStatusCode());
    }

    @Override
    public IdcContext.HttpAuthScheme getAuthScheme() {
        return IdcContext.HttpAuthScheme.LoginForm;
    }

    @Override
    public int sendAuthenticatedRequest() throws ProtocolException {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        if (context.hasCredentials() && context.getCookie(context.getSessionCookie()) == null) {
            this.handleFormLogin();
        }
        int status = this.getHttpProtocol().sendRequest();
        if (context.hasCredentials() && RIDCHttpClientUtils.isRedirectStatus(status)) {
            if (this.m_log.isLogEnabled(ILog.Level.INFO)) {
                this.m_log.log(RIDCMessages.protocol_session_invalid_reauthorizing(context.getCookie(context.getSessionCookie())), ILog.Level.INFO);
            }
            this.handleFormLogin();
            status = this.getHttpProtocol().sendRequest();
        }
        return status;
    }

    protected void handleFormLogin() throws ProtocolException {
        RIDCHttpPostMethod postMethod = this.createLoginMethod();
        int status = this.executeLogin(postMethod);
        this.handleFormResponse(postMethod, status);
    }

    protected RIDCHttpClient createHttpClient() throws ProtocolException {
        try {
            IdcHttpClientConfig clientConfig = this.getHttpProtocol().getClientConfig();
            return RIDCHttpClientUtils.createHttpClient(clientConfig, true);
        }
        catch (IdcClientException e) {
            throw new ProtocolException(e);
        }
    }

    protected int executeLogin(RIDCHttpPostMethod postMethod) throws ProtocolException {
        int status = 0;
        try {
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
                this.m_log.log(RIDCMessages.protocol_attempting_form_login(postMethod.getURI()), ILog.Level.DEBUG);
            }
            status = postMethod.execute();
        }
        catch (Exception exp) {
            throw new ProtocolException(exp);
        }
        finally {
            postMethod.releaseConnection();
        }
        return status;
    }

    protected RIDCHttpPostMethod createLoginMethod() throws ProtocolException {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        IdcContext.LoginForm loginForm = this.getLoginForm();
        String path = this.getLoginFormPath(loginForm);
        RIDCHttpPostMethod postMethod = this.getHttpClient().getPostMethod(path);
        postMethod.setRequestHeader("Content-Type", this.getHttpProtocol().getClientConfig().getContentType());
        RIDCHttpClientUtils.addRequestData(this.getHttpProtocol().getServiceRequest().getUserContext(), this.getHttpClient(), postMethod, false);
        if (context.getCredentials() instanceof Credentials.BasicCredentials) {
            Credentials.BasicCredentials credentials = (Credentials.BasicCredentials)context.getCredentials();
            try {
                postMethod.addLoginFormCredentials(loginForm, credentials);
            }
            catch (UnsupportedEncodingException e) {
                throw new ProtocolException(e);
            }
        }
        return postMethod;
    }

    protected String getLoginFormPath(IdcContext.LoginForm loginForm) throws ProtocolException {
        URI location = null;
        if (this.getPingMethod() != null) {
            try {
                location = new URI(this.getPingMethod().getURI().toString());
            }
            catch (Exception exp) {
                // empty catch block
            }
        }
        if (location == null) {
            if (this.getPingMethod() != null) {
                this.m_log.log(RIDCMessages.protocol_unable_to_use_location(), ILog.Level.DEBUG);
            }
            try {
                location = new URI(this.getHttpProtocol().getClientConfig().getConnectionString());
            }
            catch (Exception exp) {
                throw new ProtocolException(exp);
            }
        }
        String path = null;
        try {
            URI actionPath = new URI(loginForm.getActionUrl());
            if (actionPath.getScheme() != null) {
                path = loginForm.getActionUrl();
            }
        }
        catch (URISyntaxException exp) {
            // empty catch block
        }
        if (path == null) {
            if (loginForm.getActionUrl().startsWith("/")) {
                path = loginForm.getActionUrl();
            } else {
                path = location.getPath();
                int index = path.lastIndexOf(47);
                if (index != -1) {
                    path = path.substring(0, index);
                }
                path = path + "/" + loginForm.getActionUrl();
            }
            try {
                if (this.getPingMethod() != null) {
                    URI origUri = this.getPingMethod().getURI();
                    path = new URI(origUri.getScheme(), origUri.getUserInfo(), origUri.getHost(), origUri.getPort(), path, null, null).toString();
                } else {
                    URI origUri = new URI(this.getHttpProtocol().getClientConfig().getConnectionString());
                    path = new URI(origUri.getScheme(), origUri.getUserInfo(), origUri.getHost(), origUri.getPort(), path, null, null).toString();
                }
            }
            catch (Exception exp) {
                throw new ProtocolException(exp);
            }
        }
        return path;
    }

    protected IdcContext.LoginForm getLoginForm() {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        IdcContext.LoginForm loginForm = context.getLoginForm();
        if (loginForm == null) {
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
                this.m_log.log(RIDCMessages.protocol_no_login_form_found(), ILog.Level.DEBUG);
            }
            loginForm = IdcContext.JAAS_FORM;
        }
        return loginForm;
    }

    protected void handleFormResponse(RIDCHttpMethod postMethod, int status) throws ProtocolException {
        if (RIDCHttpClientUtils.isRedirectStatus(status)) {
            List<RIDCCookie> mc = this.getHttpClient().getCookies();
            HashMap<String, RIDCCookie> cookies = new HashMap<String, RIDCCookie>();
            for (RIDCCookie cookie : mc) {
                cookies.put(cookie.getName(), cookie);
            }
            IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
            context.setCookies(cookies);
            return;
        }
        this.throwFormValidateException(postMethod);
    }

    protected void throwFormValidateException(RIDCHttpMethod postMethod) throws ProtocolException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        try {
            List<RIDCHttpHeader> headers = postMethod.getResponseHeaders();
            for (RIDCHttpHeader header : headers) {
                headerMap.put(header.getName(), header.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new HttpProtocolException(RIDCMessages.protocol_form_validation_failed(), 401, headerMap);
    }
}

