/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.auth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.http.utils.RIDCHttpClientUtils;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.AuthenticationHandler;
import oracle.stellent.ridc.protocol.http.HttpProtocolException;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;

public class OAM11GWebgateAuthHandler
implements AuthenticationHandler {
    private ILog m_log = LogFactory.getLog(this.getClass());
    private IdcHttpProtocol m_httpProtocol = null;
    private RIDCHttpClient m_httpClient = null;
    protected ServiceLog m_serviceLog = null;
    protected String m_logId = null;
    public static final String OAM_11G_WEBGATE_COOKIE_PREFIX = "OAMAuthnCookie_";
    public static final String OAM_11G_WEBGATE_COOKIE2_PREFIX = "OAMRequestContext_";

    public OAM11GWebgateAuthHandler(IdcHttpProtocol httpProtocol) {
        this.m_httpProtocol = httpProtocol;
    }

    public IdcHttpProtocol getHttpProtocol() {
        return this.m_httpProtocol;
    }

    protected void setLogId(String logId) {
        this.m_logId = logId;
    }

    protected void setServiceLog(ServiceLog log) {
        this.m_serviceLog = log;
    }

    protected ServiceLog getServiceLog() {
        if (this.m_serviceLog == null) {
            this.m_serviceLog = this.m_httpProtocol.getServiceRequest().getServiceLog();
        }
        return this.m_serviceLog;
    }

    protected String getLogId() {
        if (this.m_logId == null) {
            this.m_logId = this.getServiceLog() != null ? this.m_serviceLog.getLogId() : ServiceLog.toId(System.nanoTime());
        }
        return this.m_logId;
    }

    @Override
    public boolean isAuthSupported(RIDCHttpClient httpClient, RIDCHttpMethod pingMethod) throws ProtocolException {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        if (!(context.getCredentials() instanceof Credentials.BasicCredentials)) {
            return false;
        }
        if (RIDCHttpClientUtils.isRedirectStatus(pingMethod.getStatusCode()) && OAM11GWebgateAuthHandler.hasOAM11gWebGateCookie(httpClient)) {
            this.setHttpClient(httpClient);
            return true;
        }
        return false;
    }

    public static boolean hasOAM11gWebGateCookie(RIDCHttpClient httpClient) {
        for (RIDCCookie cookie : httpClient.getCookies()) {
            String cookieName = cookie.getName();
            if (!cookieName.startsWith(OAM_11G_WEBGATE_COOKIE_PREFIX) && !cookieName.startsWith(OAM_11G_WEBGATE_COOKIE2_PREFIX)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IdcContext.HttpAuthScheme getAuthScheme() {
        return IdcContext.HttpAuthScheme.OAM_11G_WG;
    }

    @Override
    public int sendAuthenticatedRequest() throws ProtocolException {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        if (context.hasCredentials() && context.getCookie(context.getSessionCookie()) == null) {
            this.handleLogin();
        }
        int status = this.getHttpProtocol().sendRequest();
        if (context.hasCredentials() && RIDCHttpClientUtils.isRedirectStatus(status)) {
            if (this.m_log.isLogEnabled(ILog.Level.INFO)) {
                String msg = String.format("[<>]%s %s", this.getLogId(), RIDCMessages.protocol_session_invalid_reauthorizing(context.getCookie(context.getSessionCookie())));
                this.m_log.log(msg, ILog.Level.INFO);
            }
            this.handleLogin();
            status = this.getHttpProtocol().sendRequest();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleLogin() throws ProtocolException {
        try {
            IdcHttpClientConfig clientConfig = this.getHttpProtocol().getClientConfig();
            String url = clientConfig.getConnectionString() + clientConfig.getPingService();
            RIDCHttpGetMethod pingMethod = this.getHttpClient().getGetMethod(url);
            pingMethod.setFollowRedirects(true);
            pingMethod.setServiceLog(this.getServiceLog());
            IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
            RIDCHttpClientUtils.addRequestData(context, this.getHttpClient(), pingMethod, false);
            URL oamAuthUrl = null;
            String loginPageBody = null;
            try {
                pingMethod.execute();
                if (this.isOAMLoginPageRendered(pingMethod)) {
                    oamAuthUrl = new URL(pingMethod.getURI().toURL(), "/oam/server/auth_cred_submit");
                    String charset = this.getCharsetFromContentType(pingMethod);
                    loginPageBody = StreamUtil.getStringFromStream(pingMethod.getResponseBodyAsStream(), charset);
                } else {
                    this.throwFailedAuthenticationException(pingMethod);
                }
            }
            finally {
                pingMethod.releaseConnection();
            }
            String requestId = this.extractRequestIdFromResponseBody(loginPageBody);
            if (requestId == null || requestId.trim().length() == 0) {
                this.m_log.log(String.format("[<>]%s [ERROR: OAM \"request_id\" form param not detected]\nURI: %s ; Status Code: %s\n%s", this.getLogId(), pingMethod.getURI(), pingMethod.getStatusCode(), loginPageBody), ILog.Level.TRACE);
                throw new HttpProtocolException(RIDCMessages.protocol_oam_authentication_failed(), pingMethod.getStatusCode(), null, loginPageBody);
            }
            IdcHttpClientConfig oamConfig = this.createHttpClientConfigCopy(clientConfig);
            oamConfig.setConnectionString(oamAuthUrl.toString());
            RIDCHttpClient oamhttpClient = RIDCHttpClientUtils.createHttpClient(oamConfig, false);
            for (RIDCCookie cookie : this.getHttpClient().getCookies()) {
                oamhttpClient.addCookie(cookie);
            }
            RIDCHttpPostMethod postMethod = oamhttpClient.getPostMethod(oamAuthUrl.toString());
            postMethod.setFollowRedirects(false);
            postMethod.setServiceLog(this.getServiceLog());
            postMethod.setRequestHeader("Content-Type", oamConfig.getContentType());
            RIDCHttpClientUtils.addRequestData(context, oamhttpClient, postMethod, false);
            Credentials.BasicCredentials credentials = (Credentials.BasicCredentials)context.getCredentials();
            postMethod.addParameter("userid", credentials.getUserName());
            postMethod.addParameter("password", credentials.getPassword());
            postMethod.addParameter("request_id", requestId);
            if (loginPageBody.indexOf("name=\"buttonAction\"") != -1) {
                postMethod.addParameter("buttonAction", "local");
            }
            String location = null;
            try {
                if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
                    String msg = String.format("[>>]%s %s", this.getLogId(), RIDCMessages.protocol_attempting_form_login(postMethod.getURI()));
                    this.m_log.log(msg, ILog.Level.DEBUG);
                }
                postMethod.execute();
                if (this.isOAMEncryptedReplyPageRequested(postMethod)) {
                    location = this.getLocationHeaderValue(postMethod);
                } else if (this.isLoginFailedPageRendered(postMethod)) {
                    this.throwFormValidateException(postMethod);
                } else {
                    this.throwFailedAuthenticationException(postMethod);
                }
            }
            finally {
                postMethod.releaseConnection();
            }
            IdcHttpClientConfig oamConfig2 = this.createHttpClientConfigCopy(clientConfig);
            oamConfig2.setConnectionString(location);
            RIDCHttpClient oamhttpClient2 = RIDCHttpClientUtils.createHttpClient(oamConfig2, false);
            for (RIDCCookie cookie : oamhttpClient.getCookies()) {
                oamhttpClient2.addCookie(cookie);
            }
            RIDCHttpGetMethod replyMethod = oamhttpClient2.getGetMethod(location);
            replyMethod.setFollowRedirects(true);
            replyMethod.setServiceLog(this.getServiceLog());
            RIDCHttpClientUtils.addRequestData(context, oamhttpClient2, replyMethod, false);
            try {
                replyMethod.execute();
                if (this.isPingServerResponseRendered(replyMethod)) {
                    HashMap<String, RIDCCookie> cookies = new HashMap<String, RIDCCookie>();
                    for (RIDCCookie cookie : oamhttpClient2.getCookies()) {
                        cookies.put(cookie.getName(), cookie);
                    }
                    context.setCookies(cookies);
                } else {
                    this.throwFailedAuthenticationException(replyMethod);
                }
            }
            finally {
                replyMethod.releaseConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ProtocolException(e);
        }
    }

    public RIDCHttpClient getHttpClient() throws ProtocolException {
        if (this.m_httpClient == null) {
            this.m_httpClient = this.createHttpClient();
        }
        return this.m_httpClient;
    }

    protected RIDCHttpClient createHttpClient() throws ProtocolException {
        try {
            return RIDCHttpClientUtils.createHttpClient(this.getHttpProtocol().getClientConfig(), false);
        }
        catch (IdcClientException e) {
            throw new ProtocolException(e);
        }
    }

    public void setHttpClient(RIDCHttpClient httpClient) {
        this.m_httpClient = httpClient;
    }

    private IdcHttpClientConfig createHttpClientConfigCopy(IdcHttpClientConfig clientConfig) {
        IdcHttpClientConfig copy = new IdcHttpClientConfig();
        copy.setHttpLibrary(clientConfig.getHttpLibrary());
        copy.setContentType(clientConfig.getContentType());
        copy.setSecurityRealm(clientConfig.getSecurityRealm());
        copy.setNonProxyHosts(clientConfig.getNonProxyHosts());
        copy.setUseSystemProxy(clientConfig.isUseSystemProxy());
        copy.setProxyHost(clientConfig.getProxyHost());
        copy.setProxyPort(clientConfig.getProxyPort());
        copy.setProxyRealm(clientConfig.getProxyRealm());
        copy.setProxyUsername(clientConfig.getProxyUsername());
        copy.setProxyPassword(clientConfig.getProxyPassword());
        String factory = clientConfig.getProperty("httpurlconnection.httpURLConnectionFactory");
        if (factory != null) {
            copy.setProperty("httpurlconnection.httpURLConnectionFactory", factory);
        }
        return copy;
    }

    private String getCharsetFromContentType(RIDCHttpMethod method) throws ProtocolException {
        String value;
        int charsetIdx;
        String charset = "UTF-8";
        RIDCHttpHeader header = method.getResponseHeader("Content-Type");
        String type = header == null ? null : header.getValue();
        int n = charsetIdx = type == null ? -1 : type.indexOf("charset=");
        if (charsetIdx != -1 && (value = type.substring(charsetIdx + 8)) != null) {
            int semicolIdx = value.indexOf(";");
            if (semicolIdx != -1) {
                value = value.substring(0, semicolIdx);
            }
            charset = (value = value.trim()).length() > 0 ? value : charset;
        }
        return charset;
    }

    private String extractRequestIdFromResponseBody(String body) {
        String requestId = null;
        int index = body.indexOf("name=\"request_id\"");
        if (index != -1) {
            index = body.indexOf("value=\"", index);
            String requestIdBody = body.substring(index + 7);
            requestId = requestIdBody.substring(0, requestIdBody.indexOf("\""));
        }
        return requestId;
    }

    private boolean isOAMLoginPageRendered(RIDCHttpMethod pingMethod) throws ProtocolException, URISyntaxException {
        boolean result = false;
        if (pingMethod.getStatusCode() == 200) {
            String path = pingMethod.getURI().getPath();
            RIDCHttpHeader type = pingMethod.getResponseHeader("Content-Type");
            result = type != null && type.getValue().startsWith("text/html") && "/oam/server/obrareq.cgi".equals(path);
        }
        return result;
    }

    private boolean isOAMEncryptedReplyPageRequested(RIDCHttpMethod postMethod) throws ProtocolException, URISyntaxException {
        boolean result = false;
        if (postMethod.getStatusCode() == 302) {
            String location = this.getLocationHeaderValue(postMethod);
            result = location != null && location.contains("/obrar.cgi?encreply=");
        }
        return result;
    }

    private boolean isLoginFailedPageRendered(RIDCHttpMethod postMethod) throws ProtocolException, URISyntaxException {
        RIDCHttpHeader type;
        boolean result = false;
        if (postMethod.getStatusCode() == 200 && (type = postMethod.getResponseHeader("Content-Type")) != null && type.getValue().startsWith("text/html")) {
            String charset = this.getCharsetFromContentType(postMethod);
            try {
                String body = StreamUtil.getStringFromStream(postMethod.getResponseBodyAsStream(), charset);
                result = body.indexOf("action=\"/oam/server/auth_cred_submit\"") != -1;
            }
            catch (IOException e) {
                throw new ProtocolException(e);
            }
        }
        return result;
    }

    private boolean isPingServerResponseRendered(RIDCHttpMethod method) throws ProtocolException, URISyntaxException {
        IdcHttpClientConfig clientConfig = this.getHttpProtocol().getClientConfig();
        return method.getStatusCode() == 200 && method.getURI().toString().trim().endsWith(clientConfig.getPingService());
    }

    private String getLocationHeaderValue(RIDCHttpMethod method) throws ProtocolException {
        RIDCHttpHeader location = method.getResponseHeader("Location");
        return location == null ? null : location.getValue();
    }

    protected void throwFormValidateException(RIDCHttpMethod postMethod) throws ProtocolException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        try {
            List<RIDCHttpHeader> headers = postMethod.getResponseHeaders();
            for (RIDCHttpHeader header : headers) {
                headerMap.put(header.getName(), header.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new HttpProtocolException(RIDCMessages.protocol_form_validation_failed(), postMethod.getStatusCode(), headerMap);
    }

    protected void throwFailedAuthenticationException(RIDCHttpMethod method) throws ProtocolException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        try {
            List<RIDCHttpHeader> headers = method.getResponseHeaders();
            for (RIDCHttpHeader header : headers) {
                headerMap.put(header.getName(), header.getValue());
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String body = null;
        RIDCHttpHeader type = method.getResponseHeader("Content-Type");
        if (type != null && type.getValue().startsWith("text/html")) {
            String charset = this.getCharsetFromContentType(method);
            try {
                body = StreamUtil.getStringFromStream(method.getResponseBodyAsStream(), charset);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            String uri = null;
            try {
                uri = method.getURI().toString();
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            this.m_log.log(String.format("[<>]%s [ERROR: Unexpected OAM Response]\nURI: %s ; Status Code: %s\n%s", this.getLogId(), uri, method.getStatusCode(), body), ILog.Level.TRACE);
        }
        throw new HttpProtocolException(RIDCMessages.protocol_oam_authentication_failed(), method.getStatusCode(), headerMap, body);
    }
}

