/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.auth;

import java.util.HashMap;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.utils.RIDCHttpClientUtils;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;
import oracle.stellent.ridc.protocol.http.auth.FormAuthHandler;

public class OAMSSOAuthHandler
extends FormAuthHandler {
    public static final String OBSSO_COOKIE = "ObSSOCookie";
    private ILog m_log = LogFactory.getLog(this.getClass());

    public OAMSSOAuthHandler(IdcHttpProtocol httpProtocol) {
        super(httpProtocol);
    }

    @Override
    public boolean isAuthSupported(RIDCHttpClient httpClient, RIDCHttpMethod httpMethod) throws ProtocolException {
        if (super.isAuthSupported(httpClient, httpMethod)) {
            for (RIDCCookie cookie : this.getHttpClient().getCookies()) {
                if (!cookie.getName().equals(OBSSO_COOKIE)) continue;
                this.setPingMethod(null);
                return true;
            }
        }
        return false;
    }

    @Override
    public IdcContext.HttpAuthScheme getAuthScheme() {
        return IdcContext.HttpAuthScheme.OAM_SSO;
    }

    @Override
    protected IdcContext.LoginForm getLoginForm() {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        if (context.getLoginForm() != null) {
            return context.getLoginForm();
        }
        return IdcContext.OAM_SSO_FORM;
    }

    @Override
    protected void handleFormLogin() throws ProtocolException {
        if (this.getPingMethod() == null) {
            RIDCHttpMethod pingMethod = this.createPingMethod();
            try {
                pingMethod.execute();
            }
            catch (Exception exp) {
                throw new ProtocolException(exp);
            }
            finally {
                pingMethod.releaseConnection();
                this.setPingMethod(pingMethod);
            }
        }
        super.handleFormLogin();
    }

    @Override
    protected void handleFormResponse(RIDCHttpMethod postMethod, int status) throws ProtocolException {
        super.handleFormResponse(postMethod, status);
        try {
            RIDCHttpMethod pingMethod = this.createPingMethod();
            status = pingMethod.execute();
        }
        catch (Exception exp) {
            throw new ProtocolException(exp);
        }
        if (status == 200) {
            IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
            HashMap<String, RIDCCookie> cookies = new HashMap<String, RIDCCookie>();
            for (RIDCCookie cookie : this.getHttpClient().getCookies()) {
                cookies.put(cookie.getName(), cookie);
            }
            context.setCookies(cookies);
            String sessionCookie = this.getHttpProtocol().getServiceRequest().getUserContext().getSessionCookie();
            if (this.getHttpProtocol().getServiceRequest().getUserContext().getCookie(sessionCookie) == null) {
                this.throwFormValidateException(postMethod);
            }
        }
    }

    protected RIDCHttpMethod createPingMethod() throws ProtocolException {
        String url = this.getHttpProtocol().getClientConfig().getConnectionString();
        url = url + "?IdcService=PING_SERVER&IsJava=1";
        RIDCHttpGetMethod getMethod = this.getHttpClient().getGetMethod(url);
        RIDCHttpClientUtils.addRequestData(this.getHttpProtocol().getServiceRequest().getUserContext(), this.getHttpClient(), getMethod, false);
        return getMethod;
    }
}

