/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.auth;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.http.utils.RIDCHttpClientUtils;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.IdcHttpProtocol;
import oracle.stellent.ridc.protocol.http.auth.FormAuthHandler;

public class OIMSSOAuthHandler
extends FormAuthHandler {
    public static final String SITE_QUERY_PARAM_TOKEN = "Site2pstoreToken=";
    public static final String SITE_FORM_TOKEN = "site2pstoretoken";
    private ILog m_log = LogFactory.getLog(this.getClass());
    protected String m_strSiteToken = null;
    protected String m_strAuthLocation = null;

    public OIMSSOAuthHandler(IdcHttpProtocol httpProtocol) {
        super(httpProtocol);
    }

    @Override
    public boolean isAuthSupported(RIDCHttpClient httpClient, RIDCHttpMethod httpMethod) throws ProtocolException {
        int tokenPos;
        String authLocation;
        RIDCHttpHeader locationHeader;
        boolean bIsSupported = false;
        if (super.isAuthSupported(httpClient, httpMethod) && (locationHeader = this.getPingMethod().getResponseHeader("Location")) != null && !StringTools.isEmpty(authLocation = locationHeader.getValue()) && (tokenPos = authLocation.indexOf(SITE_QUERY_PARAM_TOKEN)) > 0) {
            String siteToken = authLocation.substring(tokenPos + SITE_QUERY_PARAM_TOKEN.length());
            int nextParamPos = siteToken.indexOf(38);
            if (nextParamPos >= 0) {
                siteToken = siteToken.substring(0, nextParamPos);
            }
            if (!StringTools.isEmpty(siteToken)) {
                this.setAuthLocation(authLocation);
                this.setSiteToken(siteToken);
                bIsSupported = true;
                this.setPingMethod(null);
            }
        }
        return bIsSupported;
    }

    @Override
    public IdcContext.HttpAuthScheme getAuthScheme() {
        return IdcContext.HttpAuthScheme.OIM_SSO;
    }

    @Override
    protected IdcContext.LoginForm getLoginForm() {
        IdcContext context = this.getHttpProtocol().getServiceRequest().getUserContext();
        if (context.getLoginForm() != null) {
            return context.getLoginForm();
        }
        return IdcContext.OIM_SSO_FORM;
    }

    @Override
    protected String getLoginFormPath(IdcContext.LoginForm loginForm) throws ProtocolException {
        String path = null;
        try {
            URI actionPath = new URI(loginForm.getActionUrl());
            if (actionPath.getScheme() != null) {
                path = loginForm.getActionUrl();
            }
        }
        catch (URISyntaxException exp) {
            // empty catch block
        }
        if (path == null) {
            if (loginForm.getActionUrl().startsWith("/")) {
                path = loginForm.getActionUrl();
            } else {
                int index;
                URI location = null;
                if (this.getPingMethod() != null) {
                    try {
                        location = new URI(this.getPingMethod().getURI().toString());
                    }
                    catch (Exception exp) {
                        // empty catch block
                    }
                }
                if ((index = (path = location.getPath()).lastIndexOf(47)) != -1) {
                    path = path.substring(0, index);
                }
                path = path + "/" + loginForm.getActionUrl();
            }
            try {
                URI origUri = new URI(this.getAuthLocation());
                path = new URI(origUri.getScheme(), origUri.getUserInfo(), origUri.getHost(), origUri.getPort(), path, null, null).toString();
            }
            catch (Exception exp) {
                throw new ProtocolException(exp);
            }
        }
        if (StringTools.isEmpty(path)) {
            path = super.getLoginFormPath(loginForm);
        }
        return path;
    }

    @Override
    protected RIDCHttpPostMethod createLoginMethod() throws ProtocolException {
        RIDCHttpPostMethod postMethod = super.createLoginMethod();
        if (!StringTools.isEmpty(this.getSiteToken())) {
            postMethod.addParameter(SITE_FORM_TOKEN, this.getSiteToken());
        }
        return postMethod;
    }

    @Override
    protected void handleFormResponse(RIDCHttpMethod postMethod, int status) throws ProtocolException {
        super.handleFormResponse(postMethod, status);
        RIDCHttpMethod successMethod = null;
        try {
            successMethod = this.createRedirectMethod(postMethod);
            status = successMethod.execute();
            this.readUnusedResponseBody(successMethod);
        }
        catch (Exception exp) {
            throw new ProtocolException(exp);
        }
        finally {
            successMethod.releaseConnection();
        }
        RIDCHttpMethod pingMethod = null;
        try {
            pingMethod = this.createPingMethod();
            status = pingMethod.execute();
            this.readUnusedResponseBody(pingMethod);
        }
        catch (Exception exp) {
            throw new ProtocolException(exp);
        }
        finally {
            pingMethod.releaseConnection();
        }
        if (status == 200) {
            HashMap<String, RIDCCookie> cookies = new HashMap<String, RIDCCookie>();
            for (RIDCCookie cookie : this.getHttpClient().getCookies()) {
                cookies.put(cookie.getName(), cookie);
            }
            this.getHttpProtocol().getServiceRequest().getUserContext().setCookies(cookies);
            String sessionCookie = this.getHttpProtocol().getServiceRequest().getUserContext().getSessionCookie();
            if (this.getHttpProtocol().getServiceRequest().getUserContext().getCookie(sessionCookie) == null) {
                this.throwFormValidateException(postMethod);
            }
        }
    }

    protected RIDCHttpMethod createPingMethod() throws ProtocolException {
        String url = this.getHttpProtocol().getClientConfig().getConnectionString();
        url = url + "?IdcService=PING_SERVER&IsJava=1";
        RIDCHttpGetMethod getMethod = this.getHttpClient().getGetMethod(url);
        RIDCHttpClientUtils.addRequestData(this.getHttpProtocol().getServiceRequest().getUserContext(), this.getHttpClient(), getMethod, false);
        return getMethod;
    }

    protected RIDCHttpMethod createRedirectMethod(RIDCHttpMethod httpMethod) throws ProtocolException {
        String url;
        RIDCHttpHeader locationHeader = httpMethod.getResponseHeader("Location");
        if (locationHeader != null && (url = locationHeader.getValue()) != null) {
            RIDCHttpGetMethod getMethod = this.getHttpClient().getGetMethod(url);
            RIDCHttpClientUtils.addRequestData(this.getHttpProtocol().getServiceRequest().getUserContext(), this.getHttpClient(), getMethod, false);
            return getMethod;
        }
        return null;
    }

    protected void setSiteToken(String siteToken) {
        this.m_strSiteToken = siteToken;
    }

    protected String getSiteToken() {
        return this.m_strSiteToken;
    }

    protected void setAuthLocation(String authLocation) {
        this.m_strAuthLocation = authLocation;
    }

    protected String getAuthLocation() {
        return this.m_strAuthLocation;
    }

    protected void readUnusedResponseBody(RIDCHttpMethod method) throws IOException, ProtocolException {
        InputStream stream = method.getResponseBodyAsStream();
        if (stream != null) {
            byte[] buffer = new byte[512];
            while (stream.read(buffer) > 0) {
            }
            stream.close();
        }
    }
}

