/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.httpurlconnection.impl;

import java.nio.charset.Charset;
import oracle.stellent.ridc.auth.Credentials;

final class BasicAuth {
    private static final Charset ENCODING = Charset.forName("ISO-8859-1");
    private static final byte[] charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();

    BasicAuth() {
    }

    static String authorization(String userName, String password) {
        byte[] enc = (userName + ":" + password).getBytes(ENCODING);
        enc = BasicAuth.encodeBase64(enc);
        return "Basic " + new String(enc, ENCODING);
    }

    static String authorization(Credentials.BasicCredentials credentials) {
        return BasicAuth.authorization(credentials.getUserName(), credentials.getPassword());
    }

    private static byte[] encodeBase64(byte[] inBytes) {
        byte[] outBytes = new byte[(inBytes.length + 2) / 3 * 4];
        int ix = 0;
        int index = 0;
        while (ix < inBytes.length) {
            boolean byte2Present = false;
            boolean byte3Present = false;
            int val = BasicAuth.unsignedByteToInt(inBytes[ix]) << 8;
            if (ix + 1 < inBytes.length) {
                val |= BasicAuth.unsignedByteToInt(inBytes[ix + 1]);
                byte2Present = true;
            }
            val <<= 8;
            if (ix + 2 < inBytes.length) {
                val |= BasicAuth.unsignedByteToInt(inBytes[ix + 2]);
                byte3Present = true;
            }
            outBytes[index + 3] = (byte)(byte3Present ? charset[val & 0x3F] : 61);
            outBytes[index + 2] = (byte)(byte2Present ? charset[(val >>= 6) & 0x3F] : 61);
            outBytes[index + 1] = charset[(val >>= 6) & 0x3F];
            outBytes[index + 0] = charset[(val >>= 6) & 0x3F];
            ix += 3;
            index += 4;
        }
        return outBytes;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

