/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.httpurlconnection.impl;

import java.io.IOException;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.config.ConfigurationException;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.BasicAuth;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionFactory;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionGetMethod;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionPostMethod;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.InMemoryCookieStore;

public class HttpURLConnectionClient
implements RIDCHttpClient {
    final IdcHttpClientConfig config;
    final HttpURLConnectionFactory urlConnectionFactory;
    int socketTimeout = -1;
    boolean preemptiveAuthentication = false;
    Credentials idcCredentials = null;
    CookieStore cookieStore = new InMemoryCookieStore();
    String proxyAuthorization;

    public HttpURLConnectionClient(IdcHttpClientConfig config) throws IdcClientException {
        this.config = config;
        String urlConnectionFactoryClassName = config.getProperty("httpurlconnection.httpURLConnectionFactory");
        if (urlConnectionFactoryClassName != null) {
            try {
                Class<?> urlConnectionFactoryClass = Class.forName(urlConnectionFactoryClassName);
                this.urlConnectionFactory = (HttpURLConnectionFactory)urlConnectionFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        } else {
            this.urlConnectionFactory = new HttpURLConnectionFactory(){
                private Proxy proxy = Proxy.NO_PROXY;

                @Override
                public void setProxy(Proxy proxy) {
                    this.proxy = proxy;
                }

                @Override
                public HttpURLConnection openConnection(URL url) throws IOException {
                    return (HttpURLConnection)url.openConnection(this.proxy);
                }
            };
        }
    }

    @Override
    public void addCookie(RIDCCookie cookie) {
        HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        httpCookie.setVersion(0);
        httpCookie.setComment(cookie.getComment());
        httpCookie.setDomain(cookie.getDomain());
        httpCookie.setMaxAge(cookie.getMaxAge());
        httpCookie.setPath(cookie.getPath());
        httpCookie.setSecure(cookie.isSecure());
        this.cookieStore.add(null, httpCookie);
    }

    @Override
    public void clear() {
    }

    private RIDCCookie toRIDCCookie(HttpCookie cookie) {
        RIDCCookie ridcCookie = new RIDCCookie(cookie.getName(), cookie.getValue());
        ridcCookie.setComment(cookie.getComment());
        ridcCookie.setDomain(cookie.getDomain());
        ridcCookie.setMaxAge((int)cookie.getMaxAge());
        ridcCookie.setPath(cookie.getPath());
        ridcCookie.setSecure(cookie.getSecure());
        return ridcCookie;
    }

    @Override
    public List<RIDCCookie> getCookies() {
        ArrayList<RIDCCookie> cookies = new ArrayList<RIDCCookie>();
        for (HttpCookie cookie : this.cookieStore.getCookies()) {
            cookies.add(this.toRIDCCookie(cookie));
        }
        return cookies;
    }

    @Override
    public void resetState() {
        this.socketTimeout = -1;
        this.idcCredentials = null;
        this.preemptiveAuthentication = false;
        this.cookieStore.removeAll();
    }

    @Override
    public void setAuthenticationPreemptive(boolean b) {
        this.preemptiveAuthentication = b;
    }

    @Override
    public void setCredentials(String scope, Credentials idcCredentials) {
        this.idcCredentials = idcCredentials;
    }

    boolean hasBasicCredentials() {
        return this.idcCredentials != null && this.idcCredentials instanceof Credentials.BasicCredentials;
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyRealm) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        this.urlConnectionFactory.setProxy(proxy);
        if (proxyUsername != null) {
            this.proxyAuthorization = BasicAuth.authorization(proxyUsername, proxyPassword);
        }
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public HttpURLConnectionGetMethod getGetMethod(String url) {
        return new HttpURLConnectionGetMethod(url, this);
    }

    @Override
    public HttpURLConnectionPostMethod getPostMethod(String url) {
        return new HttpURLConnectionPostMethod(url, this);
    }

    @Override
    public Object getDelegateObject() {
        return null;
    }
}

