/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.httpurlconnection.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.impl.RIDCHttpHeaderImpl;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.HttpUtils;
import oracle.stellent.ridc.common.util.NameValuePair;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionClient;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.MultivaluedMap;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.Request;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.Response;

public abstract class HttpURLConnectionMethod
implements RIDCHttpMethod {
    private static final int MAX_REDIRECTS = 15;
    static final ILog LOG = LogFactory.getLog(HttpURLConnectionMethod.class);
    final HttpURLConnectionClient client;
    final Request request;
    private Response response;
    private String cookiePolicy;
    private int redirectCount = 0;
    protected ServiceLog serviceLog = null;
    private List<RIDCHttpHeader> responseHeaders;
    private String cookieHeader;

    protected HttpURLConnectionMethod(String uri, String method, HttpURLConnectionClient client) {
        this.client = client;
        this.request = new Request(URI.create(uri), method);
    }

    @Override
    public void addRequestHeader(String name, String value) {
        this.request.headers.add(name, value);
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException, ProtocolException {
        return this.response.getInputStream();
    }

    @Override
    public RIDCHttpHeader getResponseHeader(String headerName) throws ProtocolException {
        String headerValue = null;
        for (Map.Entry header : this.response.headers.entrySet()) {
            if (!((String)header.getKey()).equalsIgnoreCase(headerName)) continue;
            List values = (List)header.getValue();
            headerValue = values != null && values.size() > 0 ? (String)values.get(0) : null;
            break;
        }
        return headerValue != null ? new RIDCHttpHeaderImpl(headerName, headerValue) : null;
    }

    @Override
    public List<RIDCHttpHeader> getResponseHeaders() throws ProtocolException {
        if (this.responseHeaders == null) {
            ArrayList<RIDCHttpHeader> headers = new ArrayList<RIDCHttpHeader>();
            for (Map.Entry header : this.response.headers.entrySet()) {
                String name = (String)header.getKey();
                for (String value : (List)header.getValue()) {
                    headers.add(new RIDCHttpHeaderImpl(name, value));
                }
            }
            this.responseHeaders = headers;
        }
        return this.responseHeaders;
    }

    @Override
    public int getStatusCode() throws ProtocolException {
        try {
            return this.response.getStatusCode();
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    @Override
    public String getStatusLine() throws ProtocolException {
        try {
            return this.response.getStatusLine();
        }
        catch (IOException e) {
            throw new ProtocolException(e);
        }
    }

    @Override
    public URI getURI() throws URISyntaxException {
        return this.response != null ? this.response.getURI() : this.request.uri;
    }

    @Override
    public void releaseConnection() {
        if (this.response != null) {
            this.response.release();
        }
    }

    @Override
    public void setCookiePolicy(String policy) {
        this.cookiePolicy = policy;
    }

    private CookiePolicy getCookiePolicy() {
        if ("idcAllCookies".equals(this.cookiePolicy)) {
            return CookiePolicy.ACCEPT_ALL;
        }
        return CookiePolicy.ACCEPT_NONE;
    }

    @Override
    public void setParameter(String param, String value) {
    }

    static String urlencode(List<NameValuePair> paramList) {
        StringBuilder encoded = new StringBuilder();
        boolean first = true;
        for (NameValuePair param : paramList) {
            if (!first) {
                encoded.append('&');
            }
            encoded.append(HttpURLConnectionMethod.urlEncode(param.getName()));
            encoded.append('=');
            encoded.append(HttpURLConnectionMethod.urlEncode(param.getValue()));
            first = false;
        }
        return encoded.toString();
    }

    @Override
    public void setQueryString(List<NameValuePair> paramList) {
        this.request.uri = HttpUtils.replaceQueryString(this.request.uri, HttpURLConnectionMethod.urlencode(paramList));
    }

    private static final String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    @Override
    public void setRequestHeader(String headerName, String headerValue) {
        this.request.headers.putSingle(headerName, headerValue);
    }

    @Override
    public HttpURLConnectionClient getRidcClient() {
        return this.client;
    }

    @Override
    public int execute() throws IOException, ProtocolException {
        String logID = this.serviceLog != null ? this.serviceLog.getLogId() : ServiceLog.toId(System.nanoTime());
        CookieManager cookieManager = new CookieManager(this.client.cookieStore, this.getCookiePolicy());
        URL requestURL = this.request.uri.toURL();
        while (true) {
            HttpURLConnection uc = this.client.urlConnectionFactory.openConnection(requestURL);
            uc.setDoInput(true);
            uc.setRequestMethod(this.request.method);
            uc.setInstanceFollowRedirects(false);
            int timeout = this.client.socketTimeout;
            if (timeout >= 0) {
                uc.setConnectTimeout(timeout);
                uc.setReadTimeout(timeout);
            }
            this.request.proxyAuthorization(this.client.proxyAuthorization);
            if (this.client.preemptiveAuthentication && this.client.hasBasicCredentials()) {
                this.request.authorization((Credentials.BasicCredentials)this.client.idcCredentials);
            }
            this.writeOutBoundRequest(uc, cookieManager);
            this.logRequest(logID, cookieManager);
            int statusCode = uc.getResponseCode();
            this.response = new Response(uc);
            try {
                cookieManager.put(this.response.getURI(), uc.getHeaderFields());
            }
            catch (URISyntaxException e) {
                throw new ProtocolException(e);
            }
            this.logResponse(logID);
            boolean retry = false;
            if (this.request.followRedirects) {
                switch (statusCode) {
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: {
                        String location;
                        if (++this.redirectCount > 15 || (location = this.response.headers.getFirst("Location")) == null) break;
                        requestURL = new URL(requestURL, location);
                        try {
                            this.request.uri = requestURL.toURI();
                        }
                        catch (URISyntaxException e) {
                            MalformedURLException ioe = new MalformedURLException();
                            ioe.initCause(e);
                            throw ioe;
                        }
                        retry = true;
                    }
                }
            }
            if (!retry) {
                return statusCode;
            }
            this.response.release();
            this.response = null;
        }
    }

    void writeOutBoundRequest(HttpURLConnection uc, CookieManager cookieManager) throws IOException {
        HttpURLConnectionMethod.writeOutBoundHeaders(this.request.headers, uc);
        this.cookieHeader = null;
        List<String> cookies = cookieManager.get(this.request.uri, uc.getRequestProperties()).get("Cookie");
        if (cookies != null && !cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder(cookies.get(0));
            for (int i = 1; i < cookies.size(); ++i) {
                sb.append("; ").append(cookies.get(i));
            }
            this.cookieHeader = sb.toString();
            uc.setRequestProperty("Cookie", this.cookieHeader);
            uc.setRequestProperty("Cookie2", "$Version=1");
        }
    }

    private static void writeOutBoundHeaders(MultivaluedMap<String, String> headers, HttpURLConnection uc) {
        for (Map.Entry header : headers.entrySet()) {
            List headerValues = (List)header.getValue();
            if (headerValues.size() == 1) {
                uc.setRequestProperty((String)header.getKey(), (String)headerValues.get(0));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (String value : headerValues) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append((Object)value);
            }
            uc.setRequestProperty((String)header.getKey(), b.toString());
        }
    }

    String logRequestType() {
        return "[STANDARD REQUEST]";
    }

    abstract void logRequestBody(StringBuilder var1, Formatter var2);

    private void logRequest(String logID, CookieManager cookieManager) {
        if (!LOG.isLogEnabled(ILog.Level.TRACE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("[->]%s [STANDARD REQUEST]\n", logID);
        f.format("%s %s\n", this.request.method, this.request.uri);
        sb.append("Client cookies:\n");
        for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
            f.format("  %s; domain=%s\n", cookie, cookie.getDomain());
        }
        sb.append("Request headers:\n");
        HttpURLConnectionMethod.logHeaders(sb, f, this.request.headers);
        if (this.cookieHeader != null) {
            f.format("  Cookie: %s\n", this.cookieHeader);
            sb.append("  Cookie2: $Version=1\n");
        }
        this.logRequestBody(sb, f);
        LOG.log(sb.toString(), ILog.Level.TRACE);
    }

    private static void logHeaders(StringBuilder sb, Formatter f, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            String name = header.getKey();
            for (String value : header.getValue()) {
                if (name.endsWith("Authorization") && value != null && value.startsWith("Basic ")) {
                    value = "Basic ########";
                }
                f.format("  %s: %s\n", name, value);
            }
        }
    }

    private void logResponse(String logID) {
        if (!LOG.isLogEnabled(ILog.Level.TRACE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("[<-]%s [RESPONSE]\n", logID);
        try {
            sb.append(this.request.method).append(" response status: ").append(this.getStatusCode());
            sb.append(" ").append(this.getStatusLine()).append("\n");
        }
        catch (ProtocolException e) {
            sb.append("Error reading response status: ").append(e.getMessage());
        }
        try {
            sb.append("URI: ").append(this.getURI()).append("\n");
        }
        catch (URISyntaxException e) {
            sb.append("Error reading URI: ").append(e.getMessage());
        }
        sb.append("Client cookies: \n");
        for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
            sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
        }
        sb.append("Response headers: \n");
        HttpURLConnectionMethod.logHeaders(sb, f, this.response.headers);
        LOG.log(sb.toString(), ILog.Level.TRACE);
    }

    @Override
    public void setServiceLog(ServiceLog serviceLog) {
        this.serviceLog = serviceLog;
    }
}

