/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.httpurlconnection.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.http.utils.Multipart;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.util.NameValuePair;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionClient;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.HttpURLConnectionMethod;

public final class HttpURLConnectionPostMethod
extends HttpURLConnectionMethod
implements RIDCHttpPostMethod {
    private RequestEntity requestEntity;

    protected HttpURLConnectionPostMethod(String uri, HttpURLConnectionClient client) {
        super(uri, "POST", client);
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        if (followRedirects) {
            throw new IllegalArgumentException("Cannot follow redirects on POST");
        }
    }

    @Override
    public void setRequestEntity(String content, String contentType, String encoding) throws UnsupportedEncodingException {
        this.setRequestHeader("Content-Type", contentType + "; " + "charset=" + encoding);
        this.requestEntity = new StringEntity(content, encoding);
    }

    @Override
    public void setRequestEntity(List<RIDCHttpPart<?>> multipartParts, String encoding) throws UnsupportedEncodingException, IOException {
        String boundary = UUID.randomUUID().toString();
        this.setRequestHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
        this.requestEntity = new MultipartEntity(multipartParts, boundary);
    }

    private FormDataEntity getFormDataEntity() {
        if (this.requestEntity == null) {
            this.requestEntity = new FormDataEntity();
        }
        return (FormDataEntity)this.requestEntity;
    }

    @Override
    public void addParameter(String name, String value) {
        this.getFormDataEntity().param(name, value);
    }

    @Override
    public void addLoginFormCredentials(IdcContext.LoginForm loginForm, Credentials.BasicCredentials credentials) throws UnsupportedEncodingException {
        this.addParameter(loginForm.getUsernameField(), credentials.getUserName());
        this.addParameter(loginForm.getPasswordField(), credentials.getPassword());
    }

    @Override
    void writeOutBoundRequest(HttpURLConnection uc, CookieManager cookieManager) throws IOException {
        uc.setDoOutput(true);
        super.writeOutBoundRequest(uc, cookieManager);
        if (this.requestEntity == null) {
            LOG.log("RequestEntity is null; generating a FormDataEntity", ILog.Level.WARN);
            this.requestEntity = this.getFormDataEntity();
        }
        this.requestEntity.write(uc);
    }

    @Override
    String logRequestType() {
        return this.requestEntity instanceof MultipartEntity ? "[MULTIPART REQUEST]" : "[STANDARD REQUEST]";
    }

    @Override
    void logRequestBody(StringBuilder sb, Formatter f) {
        if (this.requestEntity != null) {
            this.requestEntity.log(sb, f);
        }
    }

    private static final class FormDataEntity
    implements RequestEntity {
        private List<NameValuePair> params = new ArrayList<NameValuePair>();

        private FormDataEntity() {
        }

        void param(String name, String value) {
            this.params.add(new NameValuePair(name, value));
        }

        @Override
        public void write(HttpURLConnection uc) throws IOException {
            byte[] data = HttpURLConnectionMethod.urlencode(this.params).getBytes("UTF-8");
            uc.setFixedLengthStreamingMode(data.length);
            OutputStream out = uc.getOutputStream();
            out.write(data);
            out.close();
        }

        @Override
        public void log(StringBuilder sb, Formatter f) {
            sb.append("Request form data: \n");
            for (NameValuePair p : this.params) {
                String name = p.getName();
                String value = p.getValue();
                if (name != null && name.trim().toLowerCase(Locale.US).endsWith("password")) {
                    value = "########";
                }
                f.format("  %s: %s\n", name, value);
            }
        }
    }

    private static final class StringEntity
    implements RequestEntity {
        private final String content;
        private final byte[] data;

        private StringEntity(String content, String encoding) throws UnsupportedEncodingException {
            this.content = content;
            this.data = content.getBytes(encoding);
        }

        @Override
        public void write(HttpURLConnection uc) throws IOException {
            uc.setFixedLengthStreamingMode(this.data.length);
            OutputStream out = uc.getOutputStream();
            out.write(this.data);
            out.close();
        }

        @Override
        public void log(StringBuilder sb, Formatter f) {
            sb.append("Request data: \n");
            sb.append(this.content).append('\n');
        }
    }

    private static interface RequestEntity {
        public void write(HttpURLConnection var1) throws IOException;

        public void log(StringBuilder var1, Formatter var2);
    }

    private static class MultipartEntity
    implements RequestEntity {
        private final List<RIDCHttpPart<?>> multipartParts;
        private final String boundary;

        MultipartEntity(List<RIDCHttpPart<?>> multipartParts, String boundary) {
            this.multipartParts = multipartParts;
            this.boundary = boundary;
        }

        @Override
        public void write(HttpURLConnection uc) throws IOException {
            long contentLength = Multipart.getContentLength(this.multipartParts, this.boundary);
            if (contentLength > 0L && contentLength <= Integer.MAX_VALUE) {
                uc.setFixedLengthStreamingMode((int)contentLength);
            } else {
                uc.setChunkedStreamingMode(16384);
            }
            BufferedOutputStream out = new BufferedOutputStream(uc.getOutputStream());
            Multipart.write(out, this.multipartParts, this.boundary);
            ((OutputStream)out).close();
        }

        @Override
        public void log(StringBuilder sb, Formatter f) {
            sb.append("[Multipart body]");
        }
    }
}

