/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.httpurlconnection.impl;

import java.net.URI;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.BasicAuth;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.MultivaluedHashMap;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.MultivaluedMap;

final class Request {
    URI uri;
    final String method;
    boolean followRedirects = false;
    MultivaluedMap<String, String> headers = new MultivaluedHashMap<String, String>();

    Request(URI uri, String method) {
        this.uri = uri;
        this.method = method;
    }

    void authorization(Credentials.BasicCredentials creds) {
        if (creds != null) {
            this.headers.putSingle("Authorization", BasicAuth.authorization(creds));
        } else {
            this.headers.remove("Authorization");
        }
    }

    boolean hasAuthorization() {
        return this.headers.containsKey("Authorization");
    }

    void proxyAuthorization(String auth) {
        if (auth == null) {
            return;
        }
        this.headers.putSingle("Proxy-Connection", "Keep-Alive");
        this.headers.putSingle("Proxy-Authorization", auth);
    }
}

