/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.httpurlconnection.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.MultivaluedHashMap;
import oracle.stellent.ridc.protocol.http.httpurlconnection.impl.MultivaluedMap;

final class Response {
    private final HttpURLConnection uc;
    final MultivaluedMap<String, String> headers = new MultivaluedHashMap<String, String>();

    Response(HttpURLConnection uc) throws IOException {
        this.uc = uc;
        this.headers.putAll(uc.getHeaderFields());
        this.headers.remove(null);
    }

    InputStream getInputStream() throws IOException {
        if (this.uc.getResponseCode() < 400) {
            return this.uc.getInputStream();
        }
        InputStream ein = this.uc.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    int getStatusCode() throws IOException {
        return this.uc.getResponseCode();
    }

    String getStatusLine() throws IOException {
        return this.uc.getResponseMessage();
    }

    URI getURI() throws URISyntaxException {
        return this.uc.getURL().toURI();
    }

    boolean hasBasicAuthChallenge() {
        String wwwAuthenticate = this.headers.getFirst("WWW-Authenticate");
        return wwwAuthenticate != null && wwwAuthenticate.startsWith("Basic ");
    }

    void release() {
        this.uc.disconnect();
    }
}

