/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.oracle.impl;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Codecs;
import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientConfiguration;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.auth.impl.BasicCredentials;
import oracle.stellent.ridc.auth.impl.UserNameOnlyCredentials;
import oracle.stellent.ridc.common.http.RIDCHttpClient;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.protocol.http.IdcHttpClientConfig;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleGetMethod;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOraclePostMethod;
import oracle.stellent.ridc.protocol.http.oracle.obj.CustomCookieModule;

public class HttpOracleClient
implements RIDCHttpClient {
    private HTTPConnection m_connection = null;
    private URL m_connectionUrl;
    private IdcHttpClientConfig m_config;
    private String m_authScope = null;
    private Credentials m_idcCredentials = null;
    private AuthorizationInfo m_basicAuth = null;
    private AuthorizationInfo m_digestAuth = null;
    protected static final Class cookie_mod = CustomCookieModule.class;

    public HttpOracleClient(IdcHttpClientConfig config) throws IdcClientException {
        try {
            this.m_config = config;
            this.m_connectionUrl = new URL(config.getConnectionString());
            this.m_connection = new HTTPConnection(this.m_connectionUrl);
            this.m_connection.removeModule(CookieModule.class);
            this.m_connection.addModule(cookie_mod, 1);
            this.m_connection.setContext((Object)this);
            this.m_connection.setAllowUserInteraction(false);
        }
        catch (MalformedURLException exception) {
            throw new IdcClientException(exception);
        }
        catch (ProtocolNotSuppException exception) {
            throw new IdcClientException(exception);
        }
    }

    @Override
    public void addCookie(RIDCCookie idcCookie) {
        if (idcCookie != null) {
            Date expires = null;
            int maxAge = idcCookie.getMaxAge();
            if (maxAge > 0) {
                expires = new Date(System.currentTimeMillis() + (long)(maxAge * 1000));
            }
            Cookie cookie = new Cookie(idcCookie.getName(), idcCookie.getValue(), idcCookie.getDomain(), idcCookie.getPath(), expires, idcCookie.isSecure());
            CustomCookieModule.addCookie((Cookie)cookie, (Object)this.m_connection.getContext());
        }
    }

    @Override
    public List<RIDCCookie> getCookies() {
        ArrayList<RIDCCookie> idcCookies = new ArrayList<RIDCCookie>();
        Cookie[] cookies = CustomCookieModule.listAllCookies((Object)this.m_connection.getContext());
        if (cookies != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (cookie.hasExpired()) continue;
                long maxAge = -1L;
                if (cookie.expires() != null && (maxAge = (cookie.expires().getTime() - System.currentTimeMillis()) / 1000L) > Integer.MAX_VALUE) {
                    maxAge = Integer.MAX_VALUE;
                }
                RIDCCookie idcCookie = new RIDCCookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), (int)maxAge, cookie.isSecure());
                idcCookies.add(idcCookie);
            }
        }
        return idcCookies;
    }

    @Override
    public void clear() {
        this.m_basicAuth = null;
        this.m_digestAuth = null;
    }

    @Override
    public void resetState() {
        if (this.m_connection != null) {
            this.m_connection.stop();
            Object context = this.m_connection.getContext();
            CustomCookieModule.discardAllCookies((Object)context);
            if (this.m_basicAuth != null) {
                AuthorizationInfo.removeAuthorization((AuthorizationInfo)this.m_basicAuth, (Object)context);
                this.m_basicAuth = null;
            }
            if (this.m_digestAuth != null) {
                AuthorizationInfo.removeAuthorization((AuthorizationInfo)this.m_digestAuth, (Object)context);
                this.m_digestAuth = null;
            }
        }
        try {
            this.m_connection = new HTTPConnection(this.m_connectionUrl);
            this.m_connection.setContext((Object)this);
            this.m_connection.setAllowUserInteraction(false);
        }
        catch (ProtocolNotSuppException exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    public void setAuthenticationPreemptive(boolean preemptive) {
        if (preemptive && this.m_basicAuth != null) {
            this.m_basicAuth.addPath(this.m_connectionUrl.getPath());
        }
    }

    @Override
    public void setCredentials(String scope, Credentials idcCredentials) {
        this.m_authScope = scope;
        this.m_idcCredentials = idcCredentials;
        if (idcCredentials != null) {
            String host = this.m_connection.getHost();
            int port = this.m_connection.getPort();
            String realm = this.m_config.getSecurityRealm();
            Object context = this.m_connection.getContext();
            if (idcCredentials instanceof BasicCredentials) {
                BasicCredentials basicCreds = (BasicCredentials)idcCredentials;
                this.m_basicAuth = HttpOracleClient.addBasicAuthorization(host, port, realm, basicCreds.getUserName(), basicCreds.getPassword(), context);
                this.m_digestAuth = AuthorizationInfo.addDigestAuthorization((String)host, (int)port, (String)realm, (String)basicCreds.getUserName(), (String)basicCreds.getPassword(), (Object)context);
            } else if (idcCredentials instanceof UserNameOnlyCredentials) {
                UserNameOnlyCredentials userCreds = (UserNameOnlyCredentials)idcCredentials;
                this.m_basicAuth = HttpOracleClient.addBasicAuthorization(host, port, realm, userCreds.getUserName(), null, context);
                this.m_digestAuth = AuthorizationInfo.addDigestAuthorization((String)host, (int)port, (String)realm, (String)userCreds.getUserName(), null, (Object)context);
            }
        }
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyRealm) {
        this.m_connection.setCurrentProxy(proxyHost, proxyPort);
        if (!StringTools.isEmpty(proxyUsername)) {
            Object context = this.m_connection.getContext();
            AuthorizationInfo.addBasicAuthorization((String)proxyHost, (int)proxyPort, (String)proxyRealm, (String)proxyUsername, (String)proxyPassword, (Object)context);
            AuthorizationInfo.addDigestAuthorization((String)proxyHost, (int)proxyPort, (String)proxyRealm, (String)proxyUsername, (String)proxyPassword, (Object)context);
        }
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.m_connection.setTimeout(socketTimeout * 2);
        this.m_connection.setConnectionTimeout(socketTimeout);
    }

    @Override
    public HttpOracleGetMethod getGetMethod(String url) {
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new IllegalStateException(exception);
        }
        return new HttpOracleGetMethod(u, this);
    }

    @Override
    public HttpOraclePostMethod getPostMethod(String url) {
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new IllegalStateException(exception);
        }
        return new HttpOraclePostMethod(u, this);
    }

    public HTTPConnection getDelegateObject() {
        return this.m_connection;
    }

    protected IdcHttpClientConfig getConfig() {
        return this.m_config;
    }

    boolean canBasicAuthenticate() {
        return "any".equals(this.m_authScope) && this.m_idcCredentials != null && this.m_idcCredentials instanceof BasicCredentials;
    }

    AuthorizationInfo addBasicAuthorization(String host, int port, String realm) {
        BasicCredentials credentials = (BasicCredentials)this.m_idcCredentials;
        return HttpOracleClient.addBasicAuthorization(host, port, realm, credentials.getUserName(), credentials.getPassword(), this.m_connection.getContext());
    }

    static AuthorizationInfo addBasicAuthorization(String host, int port, String realm, String user, String passwd, Object context) {
        return AuthorizationInfo.addAuthorization((String)host, (int)port, (String)"Basic", (String)realm, (String)Codecs.base64Encode((String)(user + ":" + passwd)), (NVPair[])null, null, (Object)context);
    }

    static {
        HttpClientConfiguration.setStaleSocketCheckEnabled((boolean)true);
        HttpClientConfiguration.setSocketIdleTime((int)10);
    }
}

