/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.oracle.impl;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.http.RIDCHttpGetMethod;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleClient;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleMethod;

public class HttpOracleGetMethod
extends HttpOracleMethod
implements RIDCHttpGetMethod {
    private ILog m_log = LogFactory.getLog(HttpOracleGetMethod.class);
    private boolean m_basicAuthRetry = false;

    HttpOracleGetMethod(URL url, HttpOracleClient httpOracleClient) {
        super(url, httpOracleClient);
    }

    @Override
    public int execute() throws ProtocolException, IOException {
        NVPair[] form_data = new NVPair[this.m_formData.size()];
        form_data = this.m_formData.toArray(form_data);
        NVPair[] headers = new NVPair[this.m_headers.size()];
        headers = this.m_headers.toArray(headers);
        HTTPConnection con = this.getRidcClient().getDelegateObject();
        if (this.m_followRedirects) {
            con.addModule(redir_mod, 2);
        } else {
            con.removeModule(redir_mod);
        }
        try {
            String logID = this.m_serviceLog != null ? this.m_serviceLog.getLogId() : ServiceLog.toId(System.nanoTime());
            this.logRequest(logID, this.m_url.getFile(), headers, form_data);
            this.m_response = con.Get(this.m_url.getFile(), form_data, headers);
            int statusCode = this.m_response.getStatusCode();
            this.logResponse(logID);
            if (!this.m_basicAuthRetry && this.m_client.canBasicAuthenticate() && HttpOracleGetMethod.isBasicAuthChallenge(this.m_response)) {
                String realm = HttpOracleGetMethod.getWWWAuthenticateRealm(this.m_response);
                URI uri = this.m_response.getEffectiveURI();
                this.m_client.addBasicAuthorization(uri.getHost(), uri.getPort(), realm);
                this.m_basicAuthRetry = true;
                return this.execute();
            }
            return statusCode;
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
        catch (ParseException e) {
            throw new ProtocolException(e);
        }
    }

    private static boolean isBasicAuthChallenge(HTTPResponse response) throws IOException, ModuleException {
        if (response.getStatusCode() != 401) {
            return false;
        }
        String authHeader = response.getHeader("WWW-Authenticate");
        return authHeader != null && authHeader.startsWith("Basic ");
    }

    private static String getWWWAuthenticateRealm(HTTPResponse response) throws ParseException, IOException, ModuleException {
        String authHeader = response.getHeader("WWW-Authenticate").substring("Basic ".length());
        Vector header = Util.parseHeader((String)authHeader, (boolean)false);
        return Util.getElement((Vector)header, (String)"realm").getValue();
    }

    private void logRequest(String logID, String dest, NVPair[] headers, NVPair[] formData) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            NVPair p;
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("GET ").append(dest).append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (i = 0; i < headers.length; ++i) {
                p = headers[i];
                sb.append("  ").append(p.getName()).append(": ").append(p.getValue());
                sb.append("\n");
            }
            sb.append("Request form data: \n");
            for (i = 0; i < formData.length; ++i) {
                p = formData[i];
                sb.append("  ").append(p.getName()).append(": ");
                sb.append(p.getName() != null && p.getName().trim().toLowerCase().endsWith("password") ? "########" : p.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }

    private void logResponse(String logID) throws ProtocolException {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("GET response status: ").append(this.getStatusCode());
            sb.append(" ").append(this.getStatusLine()).append("\n");
            try {
                sb.append("URI: ").append(this.getURI()).append("\n");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Response headers: \n");
            for (RIDCHttpHeader h : this.getResponseHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[<-]%s [RESPONSE]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }
}

