/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.oracle.impl;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.RedirectionModule;
import HTTPClient.URI;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpMethod;
import oracle.stellent.ridc.common.http.impl.RIDCHttpHeaderImpl;
import oracle.stellent.ridc.common.util.NameValuePair;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleClient;

public abstract class HttpOracleMethod
implements RIDCHttpMethod {
    protected URL m_url = null;
    protected HttpOracleClient m_client = null;
    protected List<NVPair> m_headers = new ArrayList<NVPair>();
    protected List<NVPair> m_formData = new ArrayList<NVPair>();
    protected HTTPResponse m_response = null;
    protected boolean m_followRedirects = true;
    protected static final Class redir_mod = RedirectionModule.class;
    protected ServiceLog m_serviceLog;

    HttpOracleMethod(URL url, HttpOracleClient httpOracleClient) {
        this.m_url = url;
        this.m_client = httpOracleClient;
    }

    NVPair getRequestHeader(String headerName) {
        for (NVPair header : this.m_headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        NVPair pair = new NVPair(headerName, headerValue);
        this.m_headers.add(pair);
    }

    @Override
    public void setRequestHeader(String headerName, String headerValue) {
        boolean headerFound = false;
        int i = 0;
        for (NVPair header : this.m_headers) {
            if (header.getName().equalsIgnoreCase(headerName)) {
                headerFound = true;
                this.m_headers.set(i, new NVPair(headerName, headerValue));
            }
            ++i;
        }
        if (!headerFound) {
            this.addRequestHeader(headerName, headerValue);
        }
    }

    @Override
    public InputStream getResponseBodyAsStream() throws IOException, ProtocolException {
        try {
            return this.m_response.getInputStream();
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
    }

    @Override
    public RIDCHttpHeader getResponseHeader(String headerName) throws ProtocolException {
        RIDCHttpHeaderImpl responseHeader = null;
        try {
            String value = this.m_response.getHeader(headerName);
            if (value != null) {
                responseHeader = new RIDCHttpHeaderImpl(headerName.trim(), value);
            }
        }
        catch (IOException exception) {
            throw new ProtocolException(exception);
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
        return responseHeader;
    }

    @Override
    public List<RIDCHttpHeader> getResponseHeaders() throws ProtocolException {
        ArrayList<RIDCHttpHeader> responseHeaders = new ArrayList<RIDCHttpHeader>();
        try {
            Enumeration keys = this.m_response.listHeaders();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                responseHeaders.add(new RIDCHttpHeaderImpl(key, this.m_response.getHeader(key)));
            }
        }
        catch (IOException exception) {
            throw new ProtocolException(exception);
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
        return responseHeaders;
    }

    @Override
    public int getStatusCode() throws ProtocolException {
        try {
            return this.m_response.getStatusCode();
        }
        catch (IOException exception) {
            throw new ProtocolException(exception);
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
    }

    @Override
    public String getStatusLine() throws ProtocolException {
        try {
            return this.m_response.getReasonLine();
        }
        catch (IOException exception) {
            throw new ProtocolException(exception);
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
    }

    @Override
    public java.net.URI getURI() throws URISyntaxException {
        java.net.URI uri = this.m_url.toURI();
        if (this.m_response != null) {
            try {
                URI hUri = this.m_response.getEffectiveURI();
                if (hUri != null) {
                    uri = hUri.toURL().toURI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uri;
    }

    @Override
    public void releaseConnection() {
    }

    @Override
    public void setCookiePolicy(String policy) {
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.m_followRedirects = followRedirects;
    }

    @Override
    public void setParameter(String param, String value) {
    }

    @Override
    public void setQueryString(List<NameValuePair> paramList) {
        this.m_formData = new ArrayList<NVPair>();
        if (paramList != null) {
            for (NameValuePair binderPair : paramList) {
                this.m_formData.add(new NVPair(binderPair.getName(), binderPair.getValue()));
            }
        }
    }

    @Override
    public HttpOracleClient getRidcClient() {
        return this.m_client;
    }

    @Override
    public void setServiceLog(ServiceLog serviceLog) {
        this.m_serviceLog = serviceLog;
    }
}

