/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.oracle.impl;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.common.http.RIDCHttpHeader;
import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.common.http.RIDCHttpPostMethod;
import oracle.stellent.ridc.common.http.utils.Multipart;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleClient;
import oracle.stellent.ridc.protocol.http.oracle.impl.HttpOracleMethod;

public class HttpOraclePostMethod
extends HttpOracleMethod
implements RIDCHttpPostMethod {
    private ILog m_log = LogFactory.getLog(HttpOraclePostMethod.class);
    byte[] m_data = null;
    private List<RIDCHttpPart<?>> m_multipartParts;
    private String m_encoding;

    HttpOraclePostMethod(URL url, HttpOracleClient httpOracleClient) {
        super(url, httpOracleClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute() throws ProtocolException, IOException {
        HTTPConnection con = this.getRidcClient().getDelegateObject();
        con.removeModule(redir_mod);
        NVPair[] form_data = new NVPair[this.m_formData.size()];
        form_data = this.m_formData.toArray(form_data);
        String boundary = null;
        try {
            String logID;
            if (this.m_multipartParts != null) {
                boundary = UUID.randomUUID().toString();
                this.setRequestHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
            }
            NVPair[] headers = new NVPair[this.m_headers.size()];
            headers = this.m_headers.toArray(headers);
            HTTPResponse response = null;
            String string = logID = this.m_serviceLog != null ? this.m_serviceLog.getLogId() : ServiceLog.toId(System.nanoTime());
            if (this.m_multipartParts != null) {
                OutputStream os = null;
                try {
                    this.logRequest(logID, this.m_url.getFile(), headers, this.m_multipartParts, this.m_encoding);
                    long contentLength = Multipart.getContentLength(this.m_multipartParts, boundary);
                    int chunkSize = this.getRidcClient().getConfig().getChunkSize();
                    HttpOutputStream httpOS = null;
                    if (contentLength > 0L && contentLength <= Integer.MAX_VALUE) {
                        httpOS = new HttpOutputStream((int)contentLength);
                    } else {
                        con.setChunking(true);
                        con.setChunkSize(chunkSize);
                        httpOS = new HttpOutputStream();
                    }
                    os = new BufferedOutputStream((OutputStream)httpOS, chunkSize);
                    response = con.Post(this.m_url.getFile(), httpOS, headers);
                    Multipart.write(os, this.m_multipartParts, boundary);
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            } else if (this.m_data != null) {
                this.logRequest(logID, this.m_url.getFile(), headers, this.m_data, this.m_encoding);
                response = con.Post(this.m_url.getFile(), this.m_data, headers);
            } else {
                this.logRequest(logID, this.m_url.getFile(), headers, form_data);
                response = con.Post(this.m_url.getFile(), form_data, headers);
            }
            this.m_response = response;
            int statusCode = this.m_response.getStatusCode();
            this.logResponse(logID);
            return statusCode;
        }
        catch (ModuleException exception) {
            throw new ProtocolException(exception);
        }
    }

    @Override
    public void setRequestEntity(String content, String contentType, String encoding) throws UnsupportedEncodingException {
        this.setRequestHeader("Content-Type", contentType + "; " + "charset=" + encoding);
        this.m_data = content.getBytes(encoding);
        this.m_encoding = encoding;
    }

    @Override
    public void setRequestEntity(List<RIDCHttpPart<?>> multipartParts, String encoding) {
        this.m_multipartParts = multipartParts;
        this.m_encoding = encoding;
    }

    @Override
    public void addParameter(String name, String value) {
        if (this.m_formData == null) {
            this.m_formData = new ArrayList();
        }
        this.m_formData.add(new NVPair(name, value));
    }

    @Override
    public void addLoginFormCredentials(IdcContext.LoginForm loginForm, Credentials.BasicCredentials credentials) {
        this.addParameter(loginForm.getUsernameField(), credentials.getUserName());
        this.addParameter(loginForm.getPasswordField(), credentials.getPassword());
    }

    private void logRequest(String logID, String dest, NVPair[] headers, NVPair[] formData) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            NVPair p;
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("POST ").append(dest).append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (i = 0; i < headers.length; ++i) {
                p = headers[i];
                sb.append("  ").append(p.getName()).append(": ").append(p.getValue());
                sb.append("\n");
            }
            sb.append("Request form data: \n");
            for (i = 0; i < formData.length; ++i) {
                p = formData[i];
                sb.append("  ").append(p.getName()).append(": ");
                sb.append(p.getName() != null && p.getName().trim().toLowerCase().endsWith("password") ? "########" : p.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }

    private void logRequest(String logID, String dest, NVPair[] headers, byte[] data, String encoding) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("POST ").append(dest).append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (int i = 0; i < headers.length; ++i) {
                NVPair p = headers[i];
                sb.append("  ").append(p.getName()).append(": ").append(p.getValue());
                sb.append("\n");
            }
            sb.append("Request data: \n");
            try {
                sb.append(new String(data, encoding)).append("\n");
            }
            catch (UnsupportedEncodingException e) {
                sb.append(e.getMessage()).append("\n");
            }
            this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }

    private void logRequest(String logID, String dest, NVPair[] headers, List<RIDCHttpPart<?>> multipartParts, String encoding) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("POST (multipart)").append(dest).append("\n");
            sb.append("Client cookies: \n");
            for (RIDCCookie rIDCCookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(rIDCCookie.toString()).append("; domain=").append(rIDCCookie.getDomain()).append("\n");
            }
            sb.append("Request headers: \n");
            for (int i = 0; i < headers.length; ++i) {
                NVPair nVPair = headers[i];
                sb.append("  ").append(nVPair.getName()).append(": ").append(nVPair.getValue());
                sb.append("\n");
            }
            sb.append("multipart data: \n");
            for (RIDCHttpPart<?> rIDCHttpPart : multipartParts) {
                String partName = rIDCHttpPart.getName();
                if (RIDCHttpPart.PartType.STRING == rIDCHttpPart.getType()) {
                    String partContent = (String)rIDCHttpPart.getContent();
                    sb.append("  part (string) - name:").append(partName);
                    sb.append("; content:").append(partContent).append("\n");
                    continue;
                }
                if (RIDCHttpPart.PartType.TRANSFERFILE != rIDCHttpPart.getType()) continue;
                TransferFile file = (TransferFile)rIDCHttpPart.getContent();
                String fileName = file.getFileName();
                String contentType = file.getContentType();
                long length = file.getContentLength();
                sb.append("  part (transferfile) - name:").append(partName);
                sb.append("; filename:").append(fileName);
                sb.append("; length:").append(length);
                sb.append("; contentType:").append(contentType).append("\n");
            }
            this.m_log.log(String.format("[->]%s [MULTIPART REQUEST]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }

    private void logResponse(String logID) throws ProtocolException {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("POST response status: ").append(this.getStatusCode());
            sb.append(" ").append(this.getStatusLine()).append("\n");
            try {
                sb.append("URI: ").append(this.getURI()).append("\n");
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            sb.append("Client cookies: \n");
            for (RIDCCookie cookie : this.getRidcClient().getCookies()) {
                sb.append("  ").append(cookie.toString()).append("; domain=").append(cookie.getDomain()).append("\n");
            }
            sb.append("Response headers: \n");
            for (RIDCHttpHeader h : this.getResponseHeaders()) {
                sb.append("  ").append(h.getName()).append(": ").append(h.getValue());
                sb.append("\n");
            }
            this.m_log.log(String.format("[<-]%s [RESPONSE]\n%s", logID, sb.toString()), ILog.Level.TRACE);
        }
    }
}

