/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.http.oracle.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import oracle.stellent.ridc.common.http.RIDCHttpPart;
import oracle.stellent.ridc.model.TransferFile;

public class OracleUtils {
    public static final String ContTypeHdrKey = "Content-Type";
    public static final String ContTypeHdrVal = "multipart/form-data; boundary=";
    private static final BitSet BoundChar;
    private static final String Boundary = "\r\n----------XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX-----";
    private static final String ContDisp = "\r\nContent-Disposition: form-data; name=\"";
    private static final String ContType = "\"\r\nContent-Type: ";
    private static final String FileName = "\"; filename=\"";
    private static final String PartContType = "\"\r\nContent-Type: text/plain; charset=";
    private static final byte[] DoubleNewLine;
    private static final byte[] TerminateMultipart;

    public static byte[] getMultipartBoundaryLineBytes() throws IOException {
        byte[] boundary = Boundary.getBytes("8859_1");
        for (int i = 12; i < 52; ++i) {
            int r;
            while (!BoundChar.get(r = new Random().nextInt(256))) {
            }
            boundary[i] = (byte)r;
        }
        return boundary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void multipartEncode(List<RIDCHttpPart<?>> multipartParts, String encoding, byte[] boundary, OutputStream httpOS) throws IOException {
        byte[] cont_disp_ = ContDisp.getBytes("8859_1");
        byte[] cont_type_ = ContType.getBytes("8859_1");
        byte[] file_name_ = FileName.getBytes("8859_1");
        byte[] part_cont_type_ = PartContType.getBytes("8859_1");
        byte[] chunkBuffer = new byte[16384];
        int offset = 2;
        for (RIDCHttpPart<?> p : multipartParts) {
            int chunkUsed = 0;
            System.arraycopy(boundary, offset, chunkBuffer, chunkUsed, boundary.length - offset);
            chunkUsed = boundary.length - offset;
            offset = 0;
            System.arraycopy(cont_disp_, 0, chunkBuffer, chunkUsed, cont_disp_.length);
            byte[] partName = p.getName().getBytes("8859_1");
            System.arraycopy(partName, 0, chunkBuffer, chunkUsed += cont_disp_.length, partName.length);
            chunkUsed += partName.length;
            if (RIDCHttpPart.PartType.STRING == p.getType()) {
                System.arraycopy(part_cont_type_, 0, chunkBuffer, chunkUsed, part_cont_type_.length);
                byte[] partEncoding = p.getEncoding().getBytes("8859_1");
                System.arraycopy(partEncoding, 0, chunkBuffer, chunkUsed += part_cont_type_.length, partEncoding.length);
                System.arraycopy(DoubleNewLine, 0, chunkBuffer, chunkUsed += partEncoding.length, DoubleNewLine.length);
                byte[] partContent = ((String)p.getContent()).getBytes(p.getEncoding());
                if (partContent.length + (chunkUsed += DoubleNewLine.length) > chunkBuffer.length) {
                    httpOS.write(chunkBuffer, 0, chunkUsed);
                    httpOS.write(partContent, 0, partContent.length);
                    continue;
                }
                System.arraycopy(partContent, 0, chunkBuffer, chunkUsed, partContent.length);
                httpOS.write(chunkBuffer, 0, chunkUsed += partContent.length);
                continue;
            }
            if (RIDCHttpPart.PartType.TRANSFERFILE != p.getType()) continue;
            System.arraycopy(file_name_, 0, chunkBuffer, chunkUsed, file_name_.length);
            TransferFile file = (TransferFile)p.getContent();
            byte[] fileName = file.getFileName().getBytes(p.getEncoding());
            System.arraycopy(fileName, 0, chunkBuffer, chunkUsed += file_name_.length, fileName.length);
            System.arraycopy(cont_type_, 0, chunkBuffer, chunkUsed += fileName.length, cont_type_.length);
            byte[] contentType = file.getContentType().getBytes("8859_1");
            System.arraycopy(contentType, 0, chunkBuffer, chunkUsed += cont_type_.length, contentType.length);
            System.arraycopy(DoubleNewLine, 0, chunkBuffer, chunkUsed += contentType.length, DoubleNewLine.length);
            httpOS.write(chunkBuffer, 0, chunkUsed += DoubleNewLine.length);
            long length = file.getContentLength();
            byte[] buffer = new byte[16384];
            InputStream is = null;
            try {
                is = file.getInputStream();
                int read = is.read(buffer);
                while (read != -1) {
                    httpOS.write(buffer, 0, read);
                    read = is.read(buffer);
                }
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        System.arraycopy(boundary, 0, chunkBuffer, 0, boundary.length);
        System.arraycopy(TerminateMultipart, 0, chunkBuffer, boundary.length, TerminateMultipart.length);
        httpOS.write(chunkBuffer, 0, boundary.length + TerminateMultipart.length);
    }

    static {
        int ch;
        DoubleNewLine = new byte[]{13, 10, 13, 10};
        TerminateMultipart = new byte[]{45, 45, 13, 10};
        BoundChar = new BitSet(256);
        for (ch = 48; ch <= 57; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 65; ch <= 90; ++ch) {
            BoundChar.set(ch);
        }
        for (ch = 97; ch <= 122; ++ch) {
            BoundChar.set(ch);
        }
        BoundChar.set(43);
        BoundChar.set(95);
        BoundChar.set(45);
        BoundChar.set(46);
    }
}

