/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.Connection;
import oracle.stellent.ridc.protocol.ConnectionManager;
import oracle.stellent.ridc.protocol.ConnectionPool;
import oracle.stellent.ridc.protocol.ProtocolException;

public class BlockingQueueConnectionPool<TConnection extends Connection>
implements ConnectionPool<TConnection> {
    private ILog m_log = LogFactory.getLog(this.getClass());
    private IdcClientConfig m_clientConfig = null;
    private BlockingQueue<TConnection> m_connections = null;
    private ConnectionManager<TConnection, IdcClientConfig> m_connectionManager = null;

    @Override
    public void initialize(IdcClientConfig clientConfig, ConnectionManager<TConnection, IdcClientConfig> connectionManager) throws ProtocolException {
        this.m_clientConfig = clientConfig;
        this.m_connectionManager = connectionManager;
        this.m_connections = new ArrayBlockingQueue<TConnection>(clientConfig.getConnectionSize());
        for (int i = 0; i < clientConfig.getConnectionSize(); ++i) {
            this.m_connections.add(this.m_connectionManager.createConnection(clientConfig));
        }
    }

    @Override
    public TConnection acquireConnection() throws ProtocolException {
        Connection connection = null;
        try {
            connection = (Connection)this.m_connections.poll(this.m_clientConfig.getConnectionWaitTime(), TimeUnit.MILLISECONDS);
            if (connection == null) {
                throw new ProtocolException(RIDCMessages.protocol_unable_to_obtain_connection(this.m_clientConfig.getConnectionWaitTime() / 1000L));
            }
            try {
                this.m_connectionManager.initializeConnection(connection);
            }
            catch (Exception exception) {
                if (connection != null) {
                    this.releaseConnection(connection);
                }
                throw new ProtocolException(RIDCMessages.protocol_unable_to_initialize_connection(exception.getMessage()));
            }
        }
        catch (InterruptedException exp) {
            throw new ProtocolException(RIDCMessages.protocol_unable_to_acquire_connection(), (Throwable)exp);
        }
        return (TConnection)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(TConnection connection) {
        try {
            this.m_connectionManager.cleanupConnection(connection);
        }
        catch (Exception exp) {
            this.m_log.log(RIDCMessages.protocol_error_cleaning_up(exp.getMessage()), (Throwable)exp, ILog.Level.ERROR);
        }
        finally {
            try {
                Thread.interrupted();
                this.m_connections.put(connection);
            }
            catch (InterruptedException exp) {
                this.m_log.log(RIDCMessages.protocol_error_returning_to_pool(exp.getMessage()), ILog.Level.ERROR);
            }
        }
    }
}

