/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.intradoc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.common.io.LengthLimitedInputStream;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.CaseInsensitiveKeyHashMap;
import oracle.stellent.ridc.common.util.HttpUtils;
import oracle.stellent.ridc.common.util.StreamUtil;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.filter.IdcFilterManager;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataBinder;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.model.DataObject;
import oracle.stellent.ridc.model.TransferFile;
import oracle.stellent.ridc.model.impl.DataBinderImpl;
import oracle.stellent.ridc.model.serialize.HdaBinderSerializer;
import oracle.stellent.ridc.model.serialize.HdaSerializerUtils;
import oracle.stellent.ridc.model.serialize.MultipartPostBinderSerializer;
import oracle.stellent.ridc.protocol.Connection;
import oracle.stellent.ridc.protocol.Protocol;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.ServiceResponse;

public abstract class HdaProtocol<TConnection extends Connection>
implements Protocol {
    public static final String HEADER_ENCODING_HEADER = "HEADER_ENCODING";
    public static final String CONTENT_TYPE_HEADER = "CONTENT_TYPE";
    public static final String USER_AGENT_HEADER = "USER-AGENT";
    public static final String HTTP_HOST_HEADER = "HTTP_HOST";
    public static final String CONTENT_LENGTH_HEADER = "CONTENT_LENGTH";
    public static final String REMOTE_USER_HEADER = "REMOTE_USER";
    public static final String REQUEST_METHOD_HEADER = "REQUEST_METHOD";
    public static final String USE_STRICT_GET = "USE_STRICT_GET";
    public static final String END_HEADERS = "$$$$\n";
    public static final String HEADER_LINE = "\r\n";
    public static final String END_SERVER_HEADERS = "\r\n\r\n";
    public static final String END_MESSAGE = "$$\r\n";
    public static final String END_HEADER_LINE = "\r\n";
    public static final String BEGIN_HDA = "<?hda";
    public static final String BEGIN_HDA_NO_HEADER = "@Prop";
    public static final String END_HDA = "@end";
    public static final String HTTP_HOST = "CIS";
    public static final int RETRY_COUNT = 2;
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String IDC_FILE = "idc-file";
    private String m_headerCharset = "UTF-8";
    private final ILog m_log = LogFactory.getLog(this.getClass());
    private long m_contentLength;
    private long m_totalLength;
    private int m_headerLength;
    private Map<String, String> m_headers;
    private DataFactory m_dataFactory = null;
    private ServiceRequest<TConnection> m_serviceRequest = null;
    private BufferedInputStream m_inputStream = null;
    private BufferedOutputStream m_outputStream = null;
    private final IdcClient m_client;
    private IdcFilterManager m_filterManager = null;

    public HdaProtocol(IdcClient client, DataFactory dataFactory, ServiceRequest<TConnection> serviceRequest) {
        this.m_client = client;
        this.m_dataFactory = dataFactory;
        this.m_serviceRequest = serviceRequest;
    }

    public DataFactory getDataFactory() {
        return this.m_dataFactory;
    }

    public ServiceRequest<TConnection> getServiceRequest() {
        return this.m_serviceRequest;
    }

    public TConnection getConnection() {
        return this.getServiceRequest().getConnection();
    }

    public InputStream getResponseStream() throws IOException {
        if (this.m_inputStream == null) {
            this.m_inputStream = new BufferedInputStream(((Connection)this.getConnection()).getInputStream());
        }
        return this.m_inputStream;
    }

    public OutputStream getRequestStream() throws IOException {
        if (this.m_outputStream == null) {
            this.m_outputStream = new BufferedOutputStream(((Connection)this.getConnection()).getOutputStream());
        }
        return this.m_outputStream;
    }

    public String getHeaderCharset() {
        return this.m_headerCharset;
    }

    public void setHeaderCharset(String headerCharset) {
        this.m_headerCharset = headerCharset;
    }

    public String getEncoding() {
        return this.getServiceRequest().getUserContext().getEncoding();
    }

    @Override
    public IdcClient getClient() {
        return this.m_client;
    }

    @Override
    public void setFilterManager(IdcFilterManager filterManager) {
        this.m_filterManager = filterManager;
    }

    @Override
    public IdcFilterManager getFilterManager() {
        return this.m_filterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRequest() throws ProtocolException {
        ServiceRequest<TConnection> serviceRequest = this.getServiceRequest();
        Map<String, String> additionalHeaders = this.getAdditionalHeaders(serviceRequest.getDataBinder());
        int retryCount = 0;
        while (retryCount < 2) {
            try {
                if (serviceRequest.getDataBinder().containsFiles()) {
                    this.writeMultipartRequest(additionalHeaders);
                    break;
                }
                this.writeStandardRequest(additionalHeaders);
                break;
            }
            catch (IOException ioErr) {
                if (retryCount >= 2 && !serviceRequest.getDataBinder().containsFiles()) {
                    serviceRequest.getServiceLog().logExceptionResponse(ioErr.getMessage());
                    throw new ProtocolException(ioErr);
                }
                if (Thread.currentThread().isInterrupted()) {
                    serviceRequest.getServiceLog().logExceptionResponse(ioErr.getMessage());
                    throw new ProtocolException(ioErr);
                }
                this.m_log.log(RIDCMessages.protocol_bad_socket_attempting_retry(retryCount + 1), ILog.Level.WARN);
                if (this.getConnection() == null) continue;
                ((Connection)this.getConnection()).close();
                ((Connection)this.getConnection()).connect();
                this.m_inputStream = null;
                this.m_outputStream = null;
            }
            finally {
                ++retryCount;
            }
        }
    }

    @Override
    public ServiceResponse readResponse() throws ProtocolException {
        ServiceResponse response = null;
        try {
            boolean hasHeaders = this.readHeaders();
            if (!hasHeaders) {
                this.m_log.log(RIDCMessages.protocol_no_headers_from_input(), ILog.Level.WARN);
            } else if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
                this.logResponseHeaders(this.getHeaders());
            }
            HdaSerializerUtils.FormatType formatType = this.getHeaders().containsKey(IDC_FILE) ? HdaSerializerUtils.FormatType.STREAM_TYPE : HdaSerializerUtils.determineFormat(this.getResponseStream(), this.getEncoding());
            CaseInsensitiveKeyHashMap<String> headers = new CaseInsensitiveKeyHashMap<String>();
            headers.putAll(this.getHeaders());
            switch (formatType) {
                case HDA_TYPE: {
                    response = new ServiceResponse(this.getDataFactory(), this.getEncoding(), headers, new LengthLimitedInputStream(this.readHdaStream(), this.m_contentLength), ServiceResponse.ResponseType.BINDER);
                    break;
                }
                case STREAM_TYPE: {
                    LengthLimitedInputStream in = new LengthLimitedInputStream(this.getResponseStream(), this.m_contentLength);
                    response = new ServiceResponse(this.getDataFactory(), this.getEncoding(), headers, in, ServiceResponse.ResponseType.STREAM);
                    break;
                }
                default: {
                    throw new ProtocolException(RIDCMessages.protocol_unable_to_determine_response_type());
                }
            }
        }
        catch (IOException exp) {
            throw new ProtocolException(exp);
        }
        return response;
    }

    protected void writeStandardRequest(Map<String, String> additionalHeaders) throws IOException {
        boolean isJava;
        ServiceRequest<TConnection> serviceRequest = this.getServiceRequest();
        DataBinder binder = serviceRequest.getDataBinder();
        HdaBinderSerializer serializer = new HdaBinderSerializer(this.getEncoding(), this.getDataFactory());
        StringBuffer body = new StringBuffer();
        boolean useStrictGet = false;
        if (binder.getLocalData().containsKey(USE_STRICT_GET)) {
            useStrictGet = true;
            binder.getLocalData().remove(USE_STRICT_GET);
        }
        if (StringTools.isEmpty((String)binder.getLocalData().get("ClientEncoding"))) {
            binder.getLocalData().put("ClientEncoding", this.getEncoding());
        }
        if (isJava = binder.getLocalData().getBoolean("IsJava", true)) {
            body.append("NoHttpHeaders=0&IsJava=1&IdcService=");
            body.append(serviceRequest.getService());
            body.append("\r\n");
            body.append("<?hda jcharset=");
            body.append(this.getEncoding());
            body.append("?>\r\n");
        } else {
            body.append(HttpUtils.createQueryFromParameters(binder.getLocalData()));
            body.append("\r\n");
        }
        if (!useStrictGet) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            serializer.serializeBinder(bout, binder);
            body.append(bout.toString(this.getEncoding()));
        }
        String bodyString = body.toString();
        byte[] bodyBytes = bodyString.getBytes(this.getEncoding());
        String header = this.getHeaderString(false, bodyBytes.length, additionalHeaders);
        this.logStandardRequest(header, bodyString);
        this.getRequestStream().write(header.getBytes(this.getEncoding()));
        this.getRequestStream().write(END_HEADERS.getBytes(this.getEncoding()));
        this.getRequestStream().write(bodyBytes);
        this.getRequestStream().flush();
    }

    protected void writeMultipartRequest(Map<String, String> additionalHeaders) throws IOException {
        ServiceRequest<TConnection> request = this.getServiceRequest();
        DataBinder binder = request.getDataBinder();
        binder.putLocal("NoHttpHeaders", "0");
        binder.putLocal("ClientEncoding", this.getEncoding());
        MultipartPostBinderSerializer serializer = new MultipartPostBinderSerializer(binder, this.getEncoding());
        serializer.prepareMultipartPost();
        long length = serializer.countBytes();
        String header = this.getHeaderString(true, length + (long)END_MESSAGE.getBytes(this.getEncoding()).length, additionalHeaders);
        this.logMultipartRequest(header, binder);
        this.getRequestStream().write(header.getBytes(this.getEncoding()));
        this.getRequestStream().write(END_HEADERS.getBytes(this.getEncoding()));
        serializer.writeBinder(this.getRequestStream());
        this.getRequestStream().write(END_MESSAGE.getBytes(this.getEncoding()));
        this.getRequestStream().flush();
    }

    protected Map<String, String> getAdditionalHeaders(DataBinder binder) {
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        DataObject localData = binder.getLocalData();
        Iterator iterator = localData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            if (StringTools.isEmpty(name) || !name.startsWith("IdcHeader:")) continue;
            String headerName = name.substring("IdcHeader:".length());
            String headerValue = (String)localData.get(name);
            additionalHeaders.put(headerName, headerValue);
            iterator.remove();
        }
        return additionalHeaders;
    }

    protected String getHeaderString(boolean isMultiPart, long contentLength, Map<String, String> additionalHeaders) {
        String idcUser = this.getServiceRequest().getUserContext().getUser();
        String userAgent = this.getServiceRequest().getUserContext().getUserAgent();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String requestMethod = "POST";
        if (additionalHeaders.containsKey(REQUEST_METHOD_HEADER)) {
            requestMethod = additionalHeaders.remove(REQUEST_METHOD_HEADER);
        }
        if (isMultiPart) {
            headerMap.put(REQUEST_METHOD_HEADER, requestMethod);
            headerMap.put(REMOTE_USER_HEADER, idcUser);
            headerMap.put(CONTENT_LENGTH_HEADER, String.valueOf(contentLength));
            headerMap.put(HTTP_HOST_HEADER, HTTP_HOST);
            if (!StringTools.isEmpty(userAgent)) {
                headerMap.put(USER_AGENT_HEADER, userAgent);
            }
            headerMap.put(CONTENT_TYPE_HEADER, "application/x-unknown");
        } else {
            headerMap.put(REQUEST_METHOD_HEADER, requestMethod);
            headerMap.put(REMOTE_USER_HEADER, idcUser);
            headerMap.put(CONTENT_TYPE_HEADER, "text/html");
            headerMap.put(CONTENT_LENGTH_HEADER, String.valueOf(contentLength));
            headerMap.put(HTTP_HOST_HEADER, HTTP_HOST);
            if (!StringTools.isEmpty(userAgent)) {
                headerMap.put(USER_AGENT_HEADER, userAgent);
            }
        }
        headerMap.put(HEADER_ENCODING_HEADER, this.getEncoding());
        headerMap.putAll(additionalHeaders);
        return this.getHeadersAsString(headerMap);
    }

    protected String getHeadersAsString(Map<String, String> headerMap) {
        StringBuffer headerBuffer = new StringBuffer();
        for (String name : headerMap.keySet()) {
            String value = headerMap.get(name);
            if (value == null) continue;
            headerBuffer.append(name).append("=").append(value).append("\n");
        }
        return headerBuffer.toString();
    }

    protected boolean readHeaders() throws IOException {
        long contentLength;
        this.getResponseStream().mark(2048);
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        boolean foundHeader = false;
        this.m_headerLength = 0;
        do {
            String line;
            if ((line = StreamUtil.readLine(this.getResponseStream(), this.getHeaderCharset())) == null || line.trim().length() < 1) {
                buffer.append(line);
                break;
            }
            list.add(line);
            this.m_headerLength += line.getBytes(this.getHeaderCharset()).length;
            if (line.indexOf(":") != -1 || line.indexOf("HTTP") != -1 || line.trim().length() < 1) {
                buffer.append(line);
                if (foundHeader) continue;
                foundHeader = true;
                continue;
            }
            if (!foundHeader) {
                this.m_log.log(RIDCMessages.protocol_non_standard_line_in_header_skipping(line), ILog.Level.WARN);
                this.getResponseStream().reset();
                return false;
            }
            this.m_log.log(RIDCMessages.protocol_non_standard_line_in_header(line), ILog.Level.WARN);
            buffer.append(line);
        } while (buffer.toString().indexOf(END_SERVER_HEADERS) == -1);
        int endHeaders = buffer.toString().indexOf(END_SERVER_HEADERS);
        if (endHeaders <= 0) {
            this.m_log.log(RIDCMessages.protocol_unable_to_find_end_header_mark(buffer.toString()), ILog.Level.WARN);
            this.getResponseStream().reset();
            return false;
        }
        String headerString = buffer.toString().substring(0, endHeaders);
        for (String aList : list) {
            String line = aList;
            int index = line.indexOf(58);
            if (index >= 0) {
                String name = line.substring(0, index);
                String value = line.substring(index + 1).trim();
                this.getHeaders().put(name, value);
                if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
                    this.m_log.log(RIDCMessages.protocol_adding_message_header(name, value), ILog.Level.TRACE);
                }
                if (!name.equalsIgnoreCase(CONTENT_LENGTH)) continue;
                try {
                    this.m_contentLength = Long.parseLong(value);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrErr) {
                    this.m_log.log(RIDCMessages.protocol_unable_to_parse_content_length(arrErr.getMessage()), ILog.Level.WARN);
                    this.getResponseStream().reset();
                    return false;
                }
                catch (NumberFormatException numErr) {
                    this.m_log.log(RIDCMessages.protocol_unable_to_parse_content_length(numErr.getMessage()), ILog.Level.WARN);
                    this.getResponseStream().reset();
                    return false;
                }
            }
            this.getHeaders().put("", line);
        }
        if (endHeaders != -1) {
            this.m_headerLength = headerString.getBytes(this.getHeaderCharset()).length + END_SERVER_HEADERS.getBytes(this.getHeaderCharset()).length;
            this.m_totalLength = (long)this.m_headerLength + this.m_contentLength;
        }
        if (this.m_totalLength <= 0L) {
            return false;
        }
        try {
            this.getResponseStream().reset();
            this.getResponseStream().skip(this.m_headerLength);
        }
        catch (IOException ioErr) {
            this.m_log.log(RIDCMessages.protocol_unable_to_reset_stream(ioErr.getMessage()), ILog.Level.WARN);
            return false;
        }
        if (this.m_headers != null && this.m_headers.containsKey("Content-Disposition") && (contentLength = HdaSerializerUtils.readIdcContentLength(this.getResponseStream())) != -1L && this.m_headers.containsKey(CONTENT_LENGTH)) {
            this.m_headers.put(CONTENT_LENGTH, String.valueOf(contentLength));
            this.m_headers.put(IDC_FILE, String.valueOf(contentLength));
            this.m_contentLength = contentLength;
        }
        return true;
    }

    protected InputStream readHdaStream() throws IOException {
        InputStream rawStream = null;
        boolean done = false;
        int bytesRead = 0;
        byte[] message = null;
        String msg = null;
        if (this.m_contentLength > 0L) {
            rawStream = this.getResponseStream();
        } else {
            this.m_log.log(RIDCMessages.protocol_no_content_length_detected(), ILog.Level.WARN);
            StringBuffer hdaBuffer = new StringBuffer();
            message = new byte[1];
            try {
                while (!done) {
                    bytesRead = this.getResponseStream().read(message);
                    hdaBuffer.append(new String(message, 0, bytesRead, this.getEncoding()));
                    if (hdaBuffer.indexOf(END_HDA) == -1) continue;
                    break;
                }
            }
            catch (IOException exp) {
                this.m_log.log(RIDCMessages.protocol_no_content_length_error(exp.getMessage()), (Throwable)exp, ILog.Level.ERROR);
            }
            byte[] bytes = msg.getBytes(this.getEncoding());
            this.m_contentLength = bytes.length;
            rawStream = new ByteArrayInputStream(bytes);
        }
        return rawStream;
    }

    protected Map<String, String> getHeaders() {
        if (this.m_headers == null) {
            this.m_headers = new HashMap<String, String>();
        }
        return this.m_headers;
    }

    private void logStandardRequest(String header, String body) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("[->]%s [STANDARD REQUEST]\n  %s%s%s", this.getServiceRequest().getServiceLog().getLogId(), header.replace("\n", "\n  "), END_HEADERS, body), ILog.Level.TRACE);
        }
    }

    private void logMultipartRequest(String header, DataBinder binder) {
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            String multipartFileInfo = "";
            Map<String, TransferFile> files = ((DataBinderImpl)binder).getFiles();
            if (files != null) {
                for (Map.Entry<String, TransferFile> file : files.entrySet()) {
                    multipartFileInfo = multipartFileInfo + String.format("{%s: %s}\n", file.getKey(), file.getValue().getFileName());
                }
            }
            this.m_log.log(String.format("[->]%s [MULTIPART REQUEST]\n  %s%s  %s  %s", this.getServiceRequest().getServiceLog().getLogId(), header.replace("\n", "\n  "), END_HEADERS, multipartFileInfo, END_MESSAGE), ILog.Level.TRACE);
        }
    }

    private void logResponseHeaders(Map<String, String> headers) {
        String logMsg = "";
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String key = header.getKey();
            if (key == null || key.trim().length() <= 0) continue;
            logMsg = logMsg + String.format("  %s: %s\n", key, header.getValue());
        }
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("[<-]%s [RESPONSE HEADERS]\n%s", this.getServiceRequest().getServiceLog().getLogId(), logMsg), ILog.Level.TRACE);
        }
    }
}

