/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.intradoc;

import java.util.HashMap;
import java.util.Map;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.protocol.ConnectionManager;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.intradoc.IntradocClientConfig;
import oracle.stellent.ridc.protocol.intradoc.IntradocProtocol;
import oracle.stellent.ridc.protocol.intradoc.socket.SSLSocketConnectionManager;
import oracle.stellent.ridc.protocol.intradoc.socket.SocketConnection;
import oracle.stellent.ridc.protocol.intradoc.socket.SocketConnectionManager;

public class IntradocClient
extends IdcClient<IntradocClientConfig, IntradocProtocol, SocketConnection> {
    private static Map<String, SocketConnectionManager> s_socketFactories = new HashMap<String, SocketConnectionManager>();

    public IntradocClient(IdcClientManager clientManager, IntradocClientConfig clientConfig) {
        super(clientManager, clientConfig);
    }

    public static void registerSocketFactory(String name, SocketConnectionManager socketFactory) {
        s_socketFactories.put(name, socketFactory);
    }

    public static SocketConnectionManager getSocketManager(String name) {
        return s_socketFactories.get(name);
    }

    @Override
    protected ConnectionManager<SocketConnection, IntradocClientConfig> createConnectionManager() {
        return IntradocClient.getSocketManager(((IntradocClientConfig)this.getConfig()).getSocketType());
    }

    @Override
    protected IntradocProtocol createProtocol(ServiceRequest<SocketConnection> serviceRequest) {
        return new IntradocProtocol((IdcClient)this, this.getDataFactory(), serviceRequest);
    }

    static {
        IntradocClient.registerSocketFactory("idc", new SocketConnectionManager());
        IntradocClient.registerSocketFactory("idcs", new SSLSocketConnectionManager());
    }
}

