/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.intradoc;

import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;

public class IntradocClientConfig
extends IdcClientConfig {
    public static final String PROP_SSL_KEYSTORE_FILE = "sslKeystoreFile";
    public static final String PROP_SSL_KEYSTORE_PASSWORD = "sslKeystorePassword";
    public static final String PROP_SSL_ALGORITHM = "sslAlgorithm";
    public static final String PROP_SSL_KEYSTORE_ALIAS = "sslKeystoreAlias";
    public static final String PROP_SSL_KEYSTORE_ALIAS_PASSWORD = "sslKeystoreAliasPassword";
    public static final String PROP_SSL_TRUST_MANAGER_FILE = "sslTrustManagerFile";
    public static final String PROP_SSL_TRUST_MANAGER_PASSWORD = "sslTrustManagerPassword";
    private String m_hostname = null;
    private int m_port = 4444;
    private String m_socketType = "idc";

    public String getHostname() {
        return this.m_hostname;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getSocketType() {
        return this.m_socketType;
    }

    public String getKeystoreFile() {
        return this.getProperty(PROP_SSL_KEYSTORE_FILE);
    }

    public void setKeystoreFile(String keytstoreFile) {
        this.setProperty(PROP_SSL_KEYSTORE_FILE, keytstoreFile);
    }

    public String getKeystorePassword() {
        return this.getProperty(PROP_SSL_KEYSTORE_PASSWORD);
    }

    public void setKeystorePassword(String password) {
        this.setProperty(PROP_SSL_KEYSTORE_PASSWORD, password);
    }

    public String getAlgorithm() {
        return this.getProperty(PROP_SSL_ALGORITHM);
    }

    public void setAlgorithm(String algorithm) {
        this.setProperty(PROP_SSL_ALGORITHM, algorithm);
    }

    public String getKeystoreAlias() {
        return this.getProperty(PROP_SSL_KEYSTORE_ALIAS);
    }

    public void setKeystoreAlias(String alias) {
        this.setProperty(PROP_SSL_KEYSTORE_ALIAS, alias);
    }

    public String getKeystoreAliasPassword() {
        return this.getProperty(PROP_SSL_KEYSTORE_ALIAS_PASSWORD);
    }

    public void setKeystoreAliasPassword(String password) {
        this.setProperty(PROP_SSL_KEYSTORE_ALIAS_PASSWORD, password);
    }

    public String getTrustManagerFile() {
        return this.getProperty(PROP_SSL_TRUST_MANAGER_FILE);
    }

    public void setTrustManagerFile(String trustFile) {
        this.setProperty(PROP_SSL_TRUST_MANAGER_FILE, trustFile);
    }

    public String getTrustManagerPassword() {
        return this.getProperty(PROP_SSL_TRUST_MANAGER_PASSWORD);
    }

    public void setTrustManagerPassword(String password) {
        this.setProperty(PROP_SSL_TRUST_MANAGER_PASSWORD, password);
    }

    @Override
    public void setConnectionString(String connectionString) {
        super.setConnectionString(connectionString);
        int index = this.getConnectionString().indexOf("://");
        if (index != -1) {
            this.m_socketType = this.getConnectionString().substring(0, index);
            String[] hostAndPort = new String[]{};
            String rawAddress = this.getConnectionString().substring(index + 3);
            if (rawAddress.startsWith("[")) {
                index = rawAddress.lastIndexOf("]");
                if (index != -1) {
                    if (index + 2 < rawAddress.length()) {
                        String host = rawAddress.substring(1, index);
                        String port = rawAddress.substring(index + 2, rawAddress.length());
                        hostAndPort = new String[]{host, port};
                    } else {
                        hostAndPort = new String[]{rawAddress.substring(1, index)};
                    }
                }
            } else {
                hostAndPort = this.getConnectionString().substring(index + 3).split(":");
            }
            if (hostAndPort.length == 1) {
                this.m_hostname = hostAndPort[0];
            } else if (hostAndPort.length == 2) {
                this.m_hostname = hostAndPort[0];
                this.m_port = Integer.parseInt(hostAndPort[1]);
            } else {
                throw new RuntimeException(RIDCMessages.protocol_malformed_connection_string(connectionString).toString());
            }
        }
    }
}

