/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.intradoc.socket;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;

public class IntradocX509KeyManager
implements X509KeyManager {
    private String m_alias;
    private X509KeyManager m_keyManager;

    public IntradocX509KeyManager(String alias, X509KeyManager keyManager) {
        this.m_alias = alias;
        this.m_keyManager = keyManager;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.m_keyManager.getPrivateKey(s);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.m_keyManager.getCertificateChain(s);
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.m_keyManager.getClientAliases(s, principals);
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.m_keyManager.getServerAliases(s, principals);
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.m_keyManager.chooseServerAlias(s, principals, socket);
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        boolean aliasFound = false;
        for (int i = 0; i < keyType.length && !aliasFound; ++i) {
            String[] validAliases = this.m_keyManager.getClientAliases(keyType[i], issuers);
            if (validAliases == null) continue;
            for (int j = 0; j < validAliases.length && !aliasFound; ++j) {
                if (!validAliases[j].equals(this.m_alias)) continue;
                aliasFound = true;
            }
        }
        if (aliasFound) {
            return this.m_alias;
        }
        return null;
    }
}

