/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.intradoc.socket;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.intradoc.IntradocClientConfig;
import oracle.stellent.ridc.protocol.intradoc.socket.IntradocX509KeyManager;
import oracle.stellent.ridc.protocol.intradoc.socket.SSLProtocolException;
import oracle.stellent.ridc.protocol.intradoc.socket.SocketConnection;

public class SSLSocketConnection
extends SocketConnection {
    private ILog m_log = LogFactory.getLog(this.getClass());

    public SSLSocketConnection(IntradocClientConfig config) {
        super(config);
    }

    @Override
    protected Socket createSocket() throws ProtocolException, IOException {
        SocketFactory sf = null;
        if (!StringTools.isEmpty(this.getConfig().getKeystoreFile())) {
            SSLContext sslc;
            TrustManagerFactory tmf;
            KeyManagerFactory kmf;
            KeyStore ks;
            try {
                ks = KeyStore.getInstance("JKS");
            }
            catch (KeyStoreException keyErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_unable_to_instantiate("Keystore", keyErr.getMessage()), (Throwable)keyErr);
            }
            try {
                ks.load(new FileInputStream(this.getConfig().getKeystoreFile()), this.getConfig().getKeystorePassword().toCharArray());
            }
            catch (Exception fileErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_not_a_valid_keystore("Keystore", this.getConfig().getKeystoreFile()), (Throwable)fileErr);
            }
            String algorithm = this.getConfig().getAlgorithm();
            if (StringTools.isEmpty(algorithm)) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            try {
                kmf = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsaErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_not_a_valid_algorithm(this.getConfig().getAlgorithm(), ""), (Throwable)nsaErr);
            }
            String password = this.getConfig().getKeystoreAliasPassword();
            if (StringTools.isEmpty(password)) {
                password = this.getConfig().getKeystorePassword();
            }
            try {
                kmf.init(ks, password.toCharArray());
            }
            catch (Exception initErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_unable_to_initialize("Keystore"), (Throwable)initErr);
            }
            KeyManager[] kms = kmf.getKeyManagers();
            if (!StringTools.isEmpty(this.getConfig().getKeystoreAlias())) {
                for (int i = 0; i < kms.length; ++i) {
                    if (!(kms[i] instanceof X509KeyManager)) continue;
                    kms[i] = new IntradocX509KeyManager(this.getConfig().getKeystoreAlias(), (X509KeyManager)kms[i]);
                }
            }
            try {
                tmf = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsaErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_not_a_valid_algorithm(this.getConfig().getAlgorithm(), "(TrustManager)"), (Throwable)nsaErr);
            }
            if (!StringTools.isEmpty(this.getConfig().getTrustManagerFile())) {
                try {
                    ks.load(new FileInputStream(this.getConfig().getTrustManagerFile()), this.getConfig().getTrustManagerPassword().toCharArray());
                }
                catch (Exception fileErr) {
                    throw new SSLProtocolException(RIDCMessages.protocol_not_a_valid_keystore("TrustManager", this.getConfig().getTrustManagerFile()), (Throwable)fileErr);
                }
            }
            try {
                tmf.init(ks);
            }
            catch (KeyStoreException keyErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_unable_to_initialize("TrustManager"), (Throwable)keyErr);
            }
            try {
                sslc = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException nsaErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_not_a_valid_algorithm("Algorithm [TLS]", "(SSLContext)"), (Throwable)nsaErr);
            }
            try {
                sslc.init(kms, tmf.getTrustManagers(), null);
            }
            catch (KeyManagementException keyManErr) {
                throw new SSLProtocolException(RIDCMessages.protocol_unable_to_initialize("SSL Context"), (Throwable)keyManErr);
            }
            sf = sslc.getSocketFactory();
        } else {
            sf = SSLSocketFactory.getDefault();
        }
        this.m_log.log(RIDCMessages.protocol_creating_new_ssl_socket(this.getConfig().getConnectionString()), ILog.Level.DEBUG);
        return sf.createSocket(this.getConfig().getHostname(), this.getConfig().getPort());
    }
}

