/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.intradoc.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import oracle.stellent.ridc.protocol.Connection;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.intradoc.IntradocClientConfig;

public class SocketConnection
extends Connection {
    private IntradocClientConfig m_config = null;
    private Socket m_socket = null;

    public SocketConnection(IntradocClientConfig config) {
        this.m_config = config;
    }

    public IntradocClientConfig getConfig() {
        return this.m_config;
    }

    @Override
    public void connect() throws ProtocolException {
        try {
            this.m_socket = this.createSocket();
            if (this.m_socket != null) {
                this.m_socket.setTcpNoDelay(true);
                this.m_socket.setSoTimeout(this.getConfig().getSocketTimeout());
            }
        }
        catch (IOException exp) {
            this.close();
            throw new ProtocolException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.reset();
        try {
            if (this.m_socket != null) {
                this.m_socket.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.m_socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isConnected()) {
            return null;
        }
        return this.m_socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.isConnected()) {
            return null;
        }
        return this.m_socket.getOutputStream();
    }

    @Override
    public boolean isConnected() {
        return this.m_socket != null && this.m_socket.isConnected() && !this.m_socket.isClosed();
    }

    public Socket getSocket() {
        return this.m_socket;
    }

    protected Socket createSocket() throws ProtocolException, IOException {
        return new Socket(this.getConfig().getHostname(), this.getConfig().getPort());
    }
}

