/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.ws.Service;
import oracle.stellent.ridc.IdcClient;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.common.xml.XPathEvaluator;
import oracle.stellent.ridc.protocol.ConnectionManager;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConnection;
import oracle.stellent.ridc.protocol.jaxws.JaxWSConnectionManager;
import oracle.stellent.ridc.protocol.jaxws.JaxWSProtocol;

public class JaxWSClient
extends IdcClient<JaxWSClientConfig, JaxWSProtocol, JaxWSClientConnection> {
    public static final String DEFAULT_REQUEST_NAMESPACE = "http://idcnativews.webservices.idcservlet/";
    public static final String DEFAULT_REQUEST_SERVICENAME = "IdcWebRequestService";
    public static final String DEFAULT_REQUEST_PORTNAME = "IdcWebRequestPort";
    public static final String DEFAULT_REQUEST_SCHEMASTRING = "";
    public static final String DEFAULT_LOGIN_NAMESPACE = "http://idcnativews.webservices.idcservlet/";
    public static final String DEFAULT_LOGIN_SERVICENAME = "IdcWebLoginService";
    public static final String DEFAULT_LOGIN_PORTNAME = "IdcWebLoginPort";
    private final Map<String, Service> m_services = new ConcurrentHashMap<String, Service>(4, 0.9f, 2);

    protected JaxWSClient(IdcClientManager clientManager, JaxWSClientConfig clientConfig) {
        super(clientManager, clientConfig);
    }

    @Override
    protected ConnectionManager<JaxWSClientConnection, JaxWSClientConfig> createConnectionManager() {
        return new JaxWSConnectionManager();
    }

    @Override
    protected JaxWSProtocol createProtocol(ServiceRequest<JaxWSClientConnection> serviceRequest) throws ProtocolException {
        return new JaxWSProtocol(this, serviceRequest, this.getDataFactory(), (JaxWSClientConfig)this.getConfig());
    }

    @Override
    public synchronized void initialize() throws IdcClientException {
        JaxWSClientConfig clientConfig = (JaxWSClientConfig)this.getConfig();
        boolean wsdlParsed = clientConfig.isWsdlParsed();
        String loginNamespace = null;
        String loginServiceName = null;
        String loginPortName = null;
        String requestNamespace = null;
        String requestServiceName = null;
        String requestPortName = null;
        String requestSchemaString = null;
        if (!wsdlParsed) {
            loginNamespace = "http://idcnativews.webservices.idcservlet/";
            loginServiceName = DEFAULT_LOGIN_SERVICENAME;
            loginPortName = DEFAULT_LOGIN_PORTNAME;
            requestNamespace = "http://idcnativews.webservices.idcservlet/";
            requestServiceName = DEFAULT_REQUEST_SERVICENAME;
            requestPortName = DEFAULT_REQUEST_PORTNAME;
            requestSchemaString = DEFAULT_REQUEST_SCHEMASTRING;
        } else {
            try {
                URL requestUrl = new URL(clientConfig.getRequestServiceWSDLUrl());
                String defaultPrefix = "wsdl";
                XPathEvaluator requestXpathEval = new XPathEvaluator(requestUrl.openStream(), null, false, defaultPrefix);
                requestNamespace = requestXpathEval.evaluateToString("@targetNamespace");
                requestServiceName = requestXpathEval.evaluateToString(defaultPrefix + ":service/@name");
                requestPortName = requestXpathEval.evaluateToString(defaultPrefix + ":service/" + defaultPrefix + ":port/@name");
                requestSchemaString = requestXpathEval.evaluateToString(defaultPrefix + ":types/xsd:schema/xsd:import/@schemaLocation");
                URL loginUrl = new URL(clientConfig.getLoginServiceWSDLUrl());
                XPathEvaluator loginXpathEval = new XPathEvaluator(loginUrl.openStream(), null, false, defaultPrefix);
                loginNamespace = loginXpathEval.evaluateToString("@targetNamespace");
                loginServiceName = loginXpathEval.evaluateToString(defaultPrefix + ":service/@name");
                loginPortName = loginXpathEval.evaluateToString(defaultPrefix + ":service/" + defaultPrefix + ":port/@name");
            }
            catch (MalformedURLException exception) {
                throw new IdcClientException(exception);
            }
            catch (IOException exception) {
                throw new IdcClientException(exception);
            }
        }
        clientConfig.setLoginNamespaceUri(loginNamespace);
        clientConfig.setLoginServiceName(loginServiceName);
        clientConfig.setLoginServicePort(loginPortName);
        clientConfig.setRequestNamespaceUri(requestNamespace);
        clientConfig.setRequestServiceName(requestServiceName);
        clientConfig.setRequestServicePort(requestPortName);
        clientConfig.setRequestSchemaUrl(requestSchemaString);
        this.initializeStack();
        super.initialize();
    }

    protected void initializeStack() throws IdcClientException {
        block9: {
            JaxWSClientConfig clientConfig = (JaxWSClientConfig)this.getConfig();
            boolean skipOptimizations = clientConfig.isStackOptimizationsSkipped();
            if (!(skipOptimizations || clientConfig.getJaxWSStack() != JaxWSClientConfig.JAXWSSTACK.jrf && clientConfig.getJaxWSStack() != JaxWSClientConfig.JAXWSSTACK.bk)) {
                try {
                    Method m;
                    Class<?> configClass = Class.forName("HTTPClient.HttpClientConfiguration");
                    if (configClass == null) break block9;
                    try {
                        m = configClass.getDeclaredMethod("setStaleSocketCheckEnabled", Boolean.TYPE);
                        if (m != null) {
                            m.invoke(null, true);
                        }
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    try {
                        m = configClass.getDeclaredMethod("setSocketIdleTime", Integer.TYPE);
                        if (m != null) {
                            m.invoke(null, 25);
                        }
                    }
                    catch (Throwable ignore) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public Map<String, Service> getServicesMap() {
        return this.m_services;
    }
}

