/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws;

import java.io.IOException;
import java.security.InvalidParameterException;
import oracle.stellent.ridc.IdcClientConfig;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.common.xml.XPathEvaluatorException;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.jaxws.xml.WSDLAndSchemaParser;

public class JaxWSClientConfig
extends IdcClientConfig {
    public static final String PROP_LOGIN_SERVICE_WSDL = "loginServiceWSDLUrl";
    public static final String PROP_REQUEST_SERVICE_WSDL = "requestServiceWSDLUrl";
    public static final String PROP_SERVER_INSTANCE_NAME = "serverInstanceName";
    public static final String PROP_SERVER_INSTANCE_NAME_DEFAULT = "/cs/";
    public static final String PROP_CSF_KEY = "csfKey";
    public static final String PROP_CLIENT_SECURITY_POLICY = "clientSecurityPolicy";
    public static final String PROP_CLIENT_SECURITY_POLICY_DEFAULT = "oracle/wss11_username_token_with_message_protection_client_policy";
    public static final String PROP_JSP_CONFIG_FILE = "jpsConfigFile";
    public static final String PROP_WSM_CONFIG_DIR = "wsmConfigDir";
    public static final String PROP_LOGIN_SERVICE_NAME = "loginServiceName";
    public static final String PROP_LOGIN_SERVICE_PORT = "loginServicePort";
    public static final String PROP_LOGIN_NAMESPACE_URI = "loginNamespaceUri";
    public static final String PROP_LOGIN_OPERATION_NAME = "loginOperationName";
    public static final String PROP_LOGIN_OPERATION_NAME_DEFAULT = "contentServerLogin";
    public static final String PROP_LOGOUT_OPERATION_NAME = "logoutOperationName";
    public static final String PROP_LOGOUT_OPERATION_NAME_DEFAULT = "contentServerLogout";
    public static final String PROP_LOGIN_SERVICE_ENDPOINT = "loginServiceEndpointUrl";
    public static final String PROP_REQUEST_SERVICE_NAME = "requestServiceName";
    public static final String PROP_REQUEST_SERVICE_PORT = "requestServicePort";
    public static final String PROP_REQUEST_NAMESPACE_URI = "requestNamespaceUri";
    public static final String PROP_REQUEST_OPERATION_NAME = "requestOperationName";
    public static final String PROP_REQUEST_OPERATION_NAME_DEFAULT = "contentServerRequest";
    public static final String PROP_REQUEST_INSTANCE_NAME_ARG = "requestInstanceNameArg";
    public static final String PROP_REQUEST_BINDER_ARG = "requestBinderArg";
    public static final String PROP_REQUEST_SCHEMA_URL = "requestSchemaUrl";
    public static final String PROP_REQUEST_SERVICE_ENDPOINT = "requestServiceEndpointUrl";
    public static final String PROP_JAXWS_STACK = "jaxWsStack";
    public static final String PROP_STACK_OPTIMIZATIONS_SKIPPED = "stackOptimizationsSkipped";
    public static final String PROP_WSDL_PARSED = "wsdlParsed";
    public static final String PROP_STREAMING_CHUNK_SIZE = "streamingChunkSize";
    public static final int PROP_STREAMING_CHUNK_SIZE_DEFAULT = 8192;

    public JAXWSSTACK getJaxWSStack() throws ProtocolException {
        String stack = this.getProperty(PROP_JAXWS_STACK);
        JAXWSSTACK result = null;
        if (stack == null) {
            result = JAXWSSTACK.jrf;
        } else {
            try {
                result = JAXWSSTACK.valueOf(stack);
            }
            catch (InvalidParameterException e) {
                throw new ProtocolException(e);
            }
        }
        return result;
    }

    public void setJaxWSStack(String stackName) throws ProtocolException {
        try {
            JAXWSSTACK.valueOf(stackName);
        }
        catch (InvalidParameterException e) {
            throw new ProtocolException(e);
        }
        this.setProperty(PROP_JAXWS_STACK, stackName);
    }

    public void setJaxWSStack(JAXWSSTACK stack) {
        this.setProperty(PROP_JAXWS_STACK, stack.name());
    }

    public String getLoginServiceWSDLUrl() {
        return this.getProperty(PROP_LOGIN_SERVICE_WSDL);
    }

    @Override
    public String getConnectionString() {
        return this.getRequestServiceWSDLUrl();
    }

    public void setLoginServiceWSDLUrl(String loginServiceWSDLUrl) {
        this.setProperty(PROP_LOGIN_SERVICE_WSDL, loginServiceWSDLUrl);
    }

    public String getRequestServiceWSDLUrl() {
        return this.getProperty(PROP_REQUEST_SERVICE_WSDL);
    }

    public void setRequestServiceWSDLUrl(String requestServiceWSDLUrl) {
        this.setProperty(PROP_REQUEST_SERVICE_WSDL, requestServiceWSDLUrl);
    }

    public String getLoginWSDLUrl() {
        String urlString = this.getLoginEndPointUrl();
        urlString = urlString + ".*/idcnativews/?\\s*";
        return urlString;
    }

    public String getLoginEndPointUrl() {
        String urlString = this.getConnectionString();
        urlString = StringTools.wrapIfRequired(urlString, null, "/");
        urlString = urlString + this.getLoginServicePort();
        return urlString;
    }

    public String getRequestWSDLUrl() {
        String urlString = this.getRequestEndPointUrl();
        urlString = urlString + ".*/idcnativews/?\\s*";
        return urlString;
    }

    private String getRequestEndPointUrl() {
        String urlString = this.getConnectionString();
        urlString = StringTools.wrapIfRequired(urlString, null, "/");
        urlString = urlString + this.getRequestServicePort();
        return urlString;
    }

    public String getServerInstanceName() {
        return this.getStringProperty(PROP_SERVER_INSTANCE_NAME, PROP_SERVER_INSTANCE_NAME_DEFAULT);
    }

    public void setServerInstanceName(String instanceName) {
        this.setProperty(PROP_SERVER_INSTANCE_NAME, instanceName);
    }

    public String getClientSecurityPolicy() {
        return this.getStringProperty(PROP_CLIENT_SECURITY_POLICY, null);
    }

    public void setClientSecurityPolicy(String clientSecurityPolicy) {
        this.setProperty(PROP_CLIENT_SECURITY_POLICY, clientSecurityPolicy);
    }

    public String getJpsConfigFile() {
        return this.getProperty(PROP_JSP_CONFIG_FILE);
    }

    public void setJpsConfigFile(String jpsConfigFile) {
        this.setProperty(PROP_JSP_CONFIG_FILE, jpsConfigFile);
    }

    public String getWsmConfigDir() {
        return this.getProperty(PROP_WSM_CONFIG_DIR);
    }

    public void setWsmConfigDir(String wsmConfigDir) {
        this.setProperty(PROP_WSM_CONFIG_DIR, wsmConfigDir);
    }

    public String getLoginServiceName() {
        return this.getProperty(PROP_LOGIN_SERVICE_NAME);
    }

    public void setLoginServiceName(String loginServiceName) {
        this.setProperty(PROP_LOGIN_SERVICE_NAME, loginServiceName);
    }

    public String getLoginServicePort() {
        return this.getProperty(PROP_LOGIN_SERVICE_PORT);
    }

    public void setLoginServicePort(String loginServicePort) {
        this.setProperty(PROP_LOGIN_SERVICE_PORT, loginServicePort);
    }

    public String getLoginNamespaceUri() {
        return this.getProperty(PROP_LOGIN_NAMESPACE_URI);
    }

    public void setLoginNamespaceUri(String loginNamespaceUri) {
        this.setProperty(PROP_LOGIN_NAMESPACE_URI, loginNamespaceUri);
    }

    public String getRequestServiceName() {
        return this.getProperty(PROP_REQUEST_SERVICE_NAME);
    }

    public void setRequestServiceName(String requestServiceName) {
        this.setProperty(PROP_REQUEST_SERVICE_NAME, requestServiceName);
    }

    public String getRequestServicePort() {
        return this.getProperty(PROP_REQUEST_SERVICE_PORT);
    }

    public void setRequestServicePort(String requestServicePort) {
        this.setProperty(PROP_REQUEST_SERVICE_PORT, requestServicePort);
    }

    public String getRequestNamespaceUri() {
        return this.getProperty(PROP_REQUEST_NAMESPACE_URI);
    }

    public void setRequestNamespaceUri(String requestNamespaceUri) {
        this.setProperty(PROP_REQUEST_NAMESPACE_URI, requestNamespaceUri);
    }

    public String getLoginOperationName() {
        return this.getStringProperty(PROP_LOGIN_OPERATION_NAME, PROP_LOGIN_OPERATION_NAME_DEFAULT);
    }

    public void setLoginOperationName(String loginOperationName) {
        this.setProperty(PROP_LOGIN_OPERATION_NAME, loginOperationName);
    }

    public String getLogoutOperationName() {
        return this.getStringProperty(PROP_LOGOUT_OPERATION_NAME, PROP_LOGOUT_OPERATION_NAME_DEFAULT);
    }

    public void setLogoutOperationName(String logoutOperationName) {
        this.setProperty(PROP_LOGOUT_OPERATION_NAME, logoutOperationName);
    }

    public String getRequestOperationName() {
        return this.getStringProperty(PROP_REQUEST_OPERATION_NAME, PROP_REQUEST_OPERATION_NAME_DEFAULT);
    }

    public void setRequestOperationName(String requestOperationName) {
        this.setProperty(PROP_REQUEST_OPERATION_NAME, requestOperationName);
    }

    public String getRequestInstanceNameArg() throws XPathEvaluatorException, IOException {
        String requestInstanceNameArg = this.getProperty(PROP_REQUEST_INSTANCE_NAME_ARG);
        if (requestInstanceNameArg == null) {
            WSDLAndSchemaParser.readAndSetRequestSchema(this);
        }
        return this.getProperty(PROP_REQUEST_INSTANCE_NAME_ARG);
    }

    public void setRequestInstanceNameArg(String requestInstanceNameArg) {
        this.setProperty(PROP_REQUEST_INSTANCE_NAME_ARG, requestInstanceNameArg);
    }

    public String getRequestBinderArg() throws XPathEvaluatorException, IOException {
        String requestBinderArg = this.getProperty(PROP_REQUEST_BINDER_ARG);
        if (requestBinderArg == null) {
            WSDLAndSchemaParser.readAndSetRequestSchema(this);
        }
        return this.getProperty(PROP_REQUEST_BINDER_ARG);
    }

    public void setRequestBinderArg(String requestBinderArg) {
        this.setProperty(PROP_REQUEST_BINDER_ARG, requestBinderArg);
    }

    public String getRequestSchemaUrl() {
        return this.getProperty(PROP_REQUEST_SCHEMA_URL);
    }

    public void setRequestSchemaUrl(String requestSchemaUrl) {
        this.setProperty(PROP_REQUEST_SCHEMA_URL, requestSchemaUrl);
    }

    public int getStreamingChunkSize() {
        return this.getIntProperty(PROP_STREAMING_CHUNK_SIZE, 8192);
    }

    public void setStreamingChunkSize(int streamingChunkSize) {
        this.setProperty(PROP_STREAMING_CHUNK_SIZE, String.valueOf(streamingChunkSize));
    }

    public String getLoginServiceEndpointUrl() {
        return this.getProperty(PROP_LOGIN_SERVICE_ENDPOINT);
    }

    public void setLoginServiceEndpointUrl(String loginEndpointUrl) {
        this.setProperty(PROP_LOGIN_SERVICE_ENDPOINT, loginEndpointUrl);
    }

    public String getRequestServiceEndpointUrl() {
        return this.getProperty(PROP_REQUEST_SERVICE_ENDPOINT);
    }

    public void setRequestServiceEndpointUrl(String requestEndpointUrl) {
        this.setProperty(PROP_REQUEST_SERVICE_ENDPOINT, requestEndpointUrl);
    }

    public boolean isStackOptimizationsSkipped() {
        boolean skipOptimizations = Boolean.getBoolean("ridc.jaxws.stackoptimizationsskipped");
        return skipOptimizations || this.getBooleanProperty(PROP_STACK_OPTIMIZATIONS_SKIPPED, false);
    }

    public void setStackOptimizationsSkipped(boolean stackOptimizationsSkipped) {
        this.setProperty(PROP_STACK_OPTIMIZATIONS_SKIPPED, String.valueOf(stackOptimizationsSkipped));
    }

    public boolean isWsdlParsed() {
        boolean wsdlParsed = Boolean.getBoolean("ridc.jaxws.wsdlparsed");
        return wsdlParsed || this.getBooleanProperty(PROP_WSDL_PARSED, false);
    }

    public void setWsdlParsed(boolean wsdlParsed) {
        this.setProperty(PROP_WSDL_PARSED, String.valueOf(wsdlParsed));
    }

    public static enum JAXWSSTACK {
        wls,
        jrf,
        bk;

    }
}

