/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws;

import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcClientManager;
import oracle.stellent.ridc.IdcClientProvider;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClient;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;

public class JaxWSClientProvider
implements IdcClientProvider {
    public static final String JAXWS_LOGIN_URL_ENDPOINT_FRAG = "IdcWebLoginPort";
    public static final String JAXWS_LOGIN_URL_WSDL_FRAG = "?WSDL";
    public static final String JAXWS_REQUEST_URL_ENDPOINT_FRAG = "IdcWebRequestPort";
    public static final String JAXWS_REQUEST_URL_WSDL_FRAG = "?WSDL";

    @Override
    public JaxWSClient createClient(IdcClientManager clientManager, String url) throws IdcClientException {
        JaxWSClientConfig clientConfig = new JaxWSClientConfig();
        if (!(url = url.trim()).endsWith("/")) {
            url = url + "/";
        }
        clientConfig.setLoginServiceEndpointUrl(url + JAXWS_LOGIN_URL_ENDPOINT_FRAG);
        clientConfig.setRequestServiceEndpointUrl(url + JAXWS_REQUEST_URL_ENDPOINT_FRAG);
        clientConfig.setLoginServiceWSDLUrl(clientConfig.getLoginServiceEndpointUrl() + "?WSDL");
        clientConfig.setRequestServiceWSDLUrl(clientConfig.getRequestServiceEndpointUrl() + "?WSDL");
        return new JaxWSClient(clientManager, clientConfig);
    }
}

