/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.activation.DataSource;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.intradoc.HdaProtocol;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClient;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConnection;
import oracle.stellent.ridc.protocol.jaxws.stack.JaxWSServiceStack;
import oracle.stellent.ridc.protocol.jaxws.stack.jrf.JaxWSbkServiceStack;
import oracle.stellent.ridc.protocol.jaxws.stack.jrf.JaxWSjrfServiceStack;
import oracle.stellent.ridc.protocol.jaxws.stack.wls.JaxWSwlsServiceStack;

public class JaxWSProtocol
extends HdaProtocol<JaxWSClientConnection>
implements DataSource {
    private static ILog log = LogFactory.getLog(JaxWSProtocol.class);
    private JaxWSClientConfig clientConfig = null;
    private PipedOutputStream pipedOutputStream = null;

    public JaxWSProtocol(JaxWSClient client, ServiceRequest<JaxWSClientConnection> serviceRequest, DataFactory dataFactory, JaxWSClientConfig config) throws ProtocolException {
        super(client, dataFactory, serviceRequest);
        String wsmConfigDir;
        this.clientConfig = config;
        String jpsConfigFile = this.clientConfig.getJpsConfigFile();
        if (jpsConfigFile != null) {
            System.setProperty("oracle.security.jps.config", jpsConfigFile);
        }
        if ((wsmConfigDir = this.clientConfig.getWsmConfigDir()) != null) {
            System.setProperty("oracle.domain.config.dir", wsmConfigDir);
        }
    }

    @Override
    public void writeRequest() throws ProtocolException {
        JaxWSServiceStack stack = this.getJaxWSStack();
        boolean authenticated = stack.authenticateUser();
        if (!authenticated) {
            log.log(RIDCMessages.protocol_jaxws_unable_to_authenticate_user(this.getServiceRequest().getUserContext().getUser()), ILog.Level.WARN);
            return;
        }
        stack.performServiceRequest();
    }

    @Override
    public void logout() throws ProtocolException {
        JaxWSServiceStack stack = this.getJaxWSStack();
        stack.logout();
    }

    protected JaxWSServiceStack getJaxWSStack() throws ProtocolException {
        JaxWSwlsServiceStack stack = null;
        switch (this.clientConfig.getJaxWSStack()) {
            case wls: {
                stack = new JaxWSwlsServiceStack(this.getServiceRequest(), this.getDataFactory(), this.clientConfig, this);
                break;
            }
            case jrf: {
                stack = new JaxWSjrfServiceStack(this.getServiceRequest(), this.getDataFactory(), this.clientConfig, this);
                break;
            }
            case bk: {
                stack = new JaxWSbkServiceStack(this.getServiceRequest(), this.getDataFactory(), this.clientConfig, this);
            }
        }
        return stack;
    }

    public void writeSuperRequest() throws IOException, ProtocolException {
        try {
            super.writeRequest();
            this.getRequestStream().flush();
            this.getRequestStream().close();
            this.pipedOutputStream = null;
        }
        catch (ProtocolException exception) {
            throw exception;
        }
        catch (IOException exception) {
            throw exception;
        }
    }

    @Override
    public OutputStream getRequestStream() throws IOException {
        if (this.pipedOutputStream == null) {
            this.pipedOutputStream = new PipedOutputStream();
        }
        return this.pipedOutputStream;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public InputStream getInputStream() throws IOException {
        PipedInputStream inputStream = new PipedInputStream(this.clientConfig.getStreamingChunkSize());
        inputStream.connect((PipedOutputStream)this.getRequestStream());
        new Thread("WriteRequest"){

            @Override
            public void run() {
                try {
                    JaxWSProtocol.this.writeSuperRequest();
                }
                catch (ProtocolException e) {
                    log.log(RIDCMessages.protocol_jaxws_error_writing_to_piped_input_stream(), (Throwable)e, ILog.Level.ERROR);
                }
                catch (IOException e) {
                    log.log(RIDCMessages.protocol_jaxws_error_writing_to_piped_input_stream(), (Throwable)e, ILog.Level.ERROR);
                }
            }
        }.start();
        return inputStream;
    }

    public String getName() {
        return "CIS";
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(RIDCMessages.protocol_jaxws_not_implemented().toString());
    }
}

