/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws.stack;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.client.HandlerConfiguration;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.BindingProvider;
import oracle.j2ee.ws.client.jaxws.OracleDispatchImpl;
import oracle.j2ee.ws.saaj.soap.soap11.Message11;
import oracle.stellent.ridc.IdcClientException;
import oracle.stellent.ridc.IdcContext;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.auth.Credentials;
import oracle.stellent.ridc.auth.impl.AppIdClientCredentials;
import oracle.stellent.ridc.common.log.ILog;
import oracle.stellent.ridc.common.log.LogFactory;
import oracle.stellent.ridc.common.log.Timer;
import oracle.stellent.ridc.common.log.TimerProvider;
import oracle.stellent.ridc.common.util.ServiceLog;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.filter.IdcFilterType;
import oracle.stellent.ridc.i18n.locale.RIDCMessages;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConnection;
import oracle.stellent.ridc.protocol.jaxws.JaxWSProtocol;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebLogin;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebRequest;
import oracle.wsm.policy.model.IPolicyAttachment;
import oracle.wsm.policy.model.IPolicyReference;
import oracle.wsm.policy.model.IPolicySet;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;

public abstract class JaxWSServiceStack {
    public static final String SET_COOKIE_HEADER = "Set-cookie";
    private ILog m_log = LogFactory.getLog(JaxWSServiceStack.class);
    private JaxWSClientConfig clientConfig = null;
    private PipedOutputStream pipedOutputStream = null;
    private DataFactory m_dataFactory = null;
    private ServiceRequest<JaxWSClientConnection> m_serviceRequest = null;
    private JaxWSClientConfig m_clientConfig = null;
    private JaxWSProtocol m_protocol;
    private final Timer timerJaxwsLogin;
    private final Timer timerJaxwsRequest;
    private static Method s_getPolicyAttachmentsMethod = null;
    private static Boolean s_getPolicyAttachmentsMethodFound = null;

    public JaxWSServiceStack(ServiceRequest<JaxWSClientConnection> serviceRequest, DataFactory dataFactory, JaxWSClientConfig config, JaxWSProtocol protocol) throws ProtocolException {
        this.m_serviceRequest = serviceRequest;
        this.m_dataFactory = dataFactory;
        this.m_clientConfig = config;
        this.m_protocol = protocol;
        ServiceLog serviceLog = this.m_serviceRequest.getServiceLog();
        String service = this.m_serviceRequest.getService();
        TimerProvider timerProvider = ServiceLog.getTimerProvider();
        this.timerJaxwsLogin = timerProvider.createTimer("jaxwsLoginRequest", service, "Jax-ws Login Request");
        this.timerJaxwsRequest = timerProvider.createTimer("jaxwsServiceRequest", service, "Jax-ws Service Request");
    }

    public ServiceRequest<JaxWSClientConnection> getServiceRequest() {
        return this.m_serviceRequest;
    }

    public JaxWSClientConfig getClientConfig() {
        return this.m_clientConfig;
    }

    public JaxWSProtocol getProtocol() {
        return this.m_protocol;
    }

    public void logCookieWarning() {
        String username = this.getServiceRequest().getUserContext().getUser();
        String hashcode = String.format("%x", this.getServiceRequest().getUserContext().hashCode());
        String cookie = this.getServiceRequest().getUserContext().getSessionCookie();
        String foundNames = "";
        for (String name : this.getServiceRequest().getUserContext().getCookieNames()) {
            foundNames = foundNames + name + ", ";
        }
        if (foundNames.length() > 2) {
            foundNames = foundNames.substring(0, foundNames.length() - 2);
        }
        this.m_log.log(RIDCMessages.protocol_jaxws_authenticate_user_cookie_not_found(username, hashcode, cookie, foundNames), ILog.Level.WARN);
    }

    public abstract IdcWebLogin getLoginPort() throws ProtocolException;

    public abstract IdcWebRequest getRequestPort() throws ProtocolException;

    public abstract boolean saveCookiesToUserContext(IdcWebLogin var1);

    public abstract void getCookiesFromUserContext(IdcContext var1, Map<String, Object> var2) throws ProtocolException;

    public abstract String getLoginStackNameForLog();

    public abstract String getRequestStackNameForLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateUser() throws ProtocolException {
        String cookie;
        String hashcode;
        String username;
        boolean result = false;
        String userName = this.getServiceRequest().getUserContext().getUser();
        if (userName != null && userName.equals("anonymous")) {
            return true;
        }
        RIDCCookie authCookie = this.getServiceRequest().getUserContext().getCookie(this.getServiceRequest().getUserContext().getSessionCookie());
        if (this.m_log.isLogEnabled(ILog.Level.DEBUG) && authCookie != null) {
            username = this.getServiceRequest().getUserContext().getUser();
            hashcode = String.format("%x", this.getServiceRequest().getUserContext().hashCode());
            cookie = String.format("%s(hash %x)", authCookie.getName(), ("ha" + authCookie.getValue() + "sh").hashCode());
            this.m_log.log(RIDCMessages.protocol_jaxws_authenticate_user_cookie_found(username, hashcode, cookie), ILog.Level.DEBUG);
        }
        if (authCookie == null) {
            if (this.m_log.isLogEnabled(ILog.Level.DEBUG)) {
                username = this.getServiceRequest().getUserContext().getUser();
                hashcode = String.format("%x", this.getServiceRequest().getUserContext().hashCode());
                cookie = this.getServiceRequest().getUserContext().getSessionCookie();
                this.m_log.log(RIDCMessages.protocol_jaxws_authenticate_user_cookie_not_found(username, hashcode, cookie, null), ILog.Level.DEBUG);
            }
            IdcWebLogin loginPort = this.getLoginPort();
            Map requestContext = ((BindingProvider)loginPort).getRequestContext();
            requestContext.put("javax.xml.ws.session.maintain", true);
            Credentials credentials = this.getServiceRequest().getUserContext().getCredentials();
            this.applyCredentialsToRequest(userName, requestContext, credentials);
            try {
                this.m_protocol.getFilterManager().executeFilters(IdcFilterType.beforeJaxwsAuthenicateUser, this.getServiceRequest().getUserContext(), this.getServiceRequest().getDataBinder(), requestContext);
            }
            catch (IdcClientException e) {
                throw new ProtocolException(e);
            }
            try {
                this.logJaxWSAuthenticateUserRequest(requestContext);
                loginPort.contentServerLogin();
                result = this.saveCookiesToUserContext(loginPort);
                Map responseContext = ((BindingProvider)loginPort).getResponseContext();
                this.logJaxWSAuthenticateUserResponse(responseContext);
            }
            finally {
                this.timerJaxwsLogin.cleanup();
            }
            return result;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performServiceRequest() throws ProtocolException {
        IdcContext userContext = this.getServiceRequest().getUserContext();
        IdcWebRequest requestPort = this.getRequestPort();
        Map requestContext = ((BindingProvider)requestPort).getRequestContext();
        requestContext.put("javax.xml.ws.session.maintain", true);
        this.getCookiesFromUserContext(userContext, requestContext);
        if (userContext.getHeaders().size() > 0) {
            for (Map.Entry<String, String> entry : userContext.getHeaders().entrySet()) {
                String header = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                requestContext.put(header, value);
            }
        }
        if (!StringTools.isEmpty(userContext.getUserAgent())) {
            requestContext.put("User-Agent", userContext.getUserAgent());
        }
        requestContext.put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", this.getClientConfig().getStreamingChunkSize());
        try {
            this.m_protocol.getFilterManager().executeFilters(IdcFilterType.beforeJaxwsServiceRequest, this.getServiceRequest().getUserContext(), this.getServiceRequest().getDataBinder(), requestContext);
        }
        catch (IdcClientException e) {
            throw new ProtocolException(e);
        }
        try {
            this.logJaxWSRequest(((BindingProvider)requestPort).getRequestContext());
            DataHandler dataHandler = new DataHandler((DataSource)this.getProtocol());
            DataHandler responseDataHandler = requestPort.contentServerRequest(this.getClientConfig().getServerInstanceName(), dataHandler);
            this.logJaxWSResponse(((BindingProvider)requestPort).getResponseContext());
            this.getServiceRequest().getConnection().setResponse(responseDataHandler);
        }
        finally {
            this.timerJaxwsRequest.cleanup();
        }
    }

    public void logout() {
        block8: {
            IdcContext context = null;
            try {
                context = this.getServiceRequest().getUserContext();
                if (context == null || context.getCookie(context.getSessionCookie()) == null) break block8;
                String userName = context.getUser();
                if (userName != null && userName.equals("anonymous")) {
                    return;
                }
                IdcWebLogin loginPort = this.getLoginPort();
                Map requestContext = ((BindingProvider)loginPort).getRequestContext();
                requestContext.put("javax.xml.ws.session.maintain", true);
                this.getCookiesFromUserContext(context, requestContext);
                if (context.getHeaders().size() > 0) {
                    for (Map.Entry<String, String> entry : context.getHeaders().entrySet()) {
                        String header = entry.getKey();
                        String value = entry.getValue();
                        if (value == null) continue;
                        requestContext.put(header, value);
                    }
                }
                if (!StringTools.isEmpty(context.getUserAgent())) {
                    requestContext.put("User-Agent", context.getUserAgent());
                }
                Credentials credentials = context.getCredentials();
                this.applyCredentialsToRequest(userName, requestContext, credentials);
                try {
                    this.m_protocol.getFilterManager().executeFilters(IdcFilterType.beforeJaxwsLogoutUser, this.getServiceRequest().getUserContext(), this.getServiceRequest().getDataBinder(), requestContext);
                }
                catch (IdcClientException e) {
                    throw new ProtocolException(e);
                }
                loginPort.contentServerLogout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void applyCredentialsToRequest(String userName, Map<String, Object> requestContext, Credentials credentials) {
        if (credentials != null) {
            requestContext.put("javax.xml.ws.security.auth.username", credentials.getUserName());
            if (credentials instanceof Credentials.BasicCredentials) {
                Credentials.BasicCredentials basicCreds = (Credentials.BasicCredentials)credentials;
                if (!StringTools.isEmpty(basicCreds.getPassword())) {
                    requestContext.put("javax.xml.ws.security.auth.password", basicCreds.getPassword());
                }
            } else if (credentials instanceof AppIdClientCredentials) {
                AppIdClientCredentials appIdCreds = (AppIdClientCredentials)credentials;
                requestContext.put("oracle.wsm.csf-key", appIdCreds.getAppId());
            }
        } else if (userName != null) {
            requestContext.put("javax.xml.ws.security.auth.username", userName);
        }
    }

    private String getLogId() {
        return this.getServiceRequest().getServiceLog().getLogId();
    }

    private void logJaxWSRequest(Map<String, Object> requestContext) {
        this.timerJaxwsRequest.start();
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("[+>]%s [JAXWS-%s]\n%s", this.getLogId(), this.getRequestStackNameForLog(), this.parseJaxContext(requestContext)), ILog.Level.TRACE);
        }
    }

    private void logJaxWSResponse(Map<String, Object> responseContext) {
        this.timerJaxwsRequest.stop();
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            this.m_log.log(String.format("[<+]%s [JAXWS-%s] %s\n%s", this.getLogId(), this.getRequestStackNameForLog(), this.timerJaxwsRequest.getElapsedTimeString(), this.parseJaxContext(responseContext)), ILog.Level.TRACE);
        }
    }

    private void logJaxWSAuthenticateUserRequest(Map<String, Object> requestContext) {
        this.timerJaxwsLogin.start();
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            String securityPolicy = "";
            if (!StringTools.isEmpty(this.m_clientConfig.getClientSecurityPolicy())) {
                securityPolicy = String.format("  Local Security Policy: %s\n", this.m_clientConfig.getClientSecurityPolicy());
            }
            String userName = "";
            Credentials credentials = this.m_serviceRequest.getUserContext().getCredentials();
            userName = credentials instanceof AppIdClientCredentials ? String.format("APPID %s", ((AppIdClientCredentials)credentials).getAppId()) : credentials.getUserName();
            this.m_log.log(String.format("[*>]%s [JAXWS-%s] authenticate user: '%s'\n%s%s", this.getLogId(), this.getRequestStackNameForLog(), userName, securityPolicy, this.parseJaxContext(requestContext)), ILog.Level.TRACE);
        }
    }

    private void logJaxWSAuthenticateUserResponse(Map<String, Object> responseContext) {
        this.timerJaxwsLogin.stop();
        if (this.m_log.isLogEnabled(ILog.Level.TRACE)) {
            String loginfo = "";
            String userName = "";
            Credentials credentials = this.m_serviceRequest.getUserContext().getCredentials();
            userName = credentials instanceof AppIdClientCredentials ? String.format("APPID %s", ((AppIdClientCredentials)credentials).getAppId()) : credentials.getUserName();
            this.m_log.log(String.format("[<*]%s [JAXWS-%s] authenticate user: '%s' %s\n%s", this.getLogId(), this.getRequestStackNameForLog(), userName, this.timerJaxwsLogin.getElapsedTimeString(), this.parseJaxContext(responseContext)), ILog.Level.TRACE);
        }
    }

    @IgnoreJRERequirement
    private String parseJaxContext(Map<String, Object> jaxContext) {
        String loginfo = "";
        for (Map.Entry<String, Object> item : jaxContext.entrySet()) {
            Map ref;
            Object value = item.getValue();
            if (value == null) continue;
            if (value instanceof Map) {
                ref = (Map)value;
                if (ref == null || ref.isEmpty()) continue;
                loginfo = loginfo + String.format("  %s:\n", item.getKey());
                for (Object key : ref.keySet()) {
                    loginfo = loginfo + String.format("    %s: %s\n", key, ref.get(key));
                }
                continue;
            }
            if (value instanceof HeaderList) {
                HeaderList headerlist = (HeaderList)value;
                for (Header header : headerlist) {
                    if (header == null) continue;
                    loginfo = loginfo + String.format("  %s\n", header.getStringContent());
                }
                continue;
            }
            if (value instanceof InputSource) {
                InputSource source = (InputSource)value;
                if (source == null) continue;
                String id = source.getPublicId();
                if (id == null) {
                    id = source.getSystemId();
                }
                loginfo = loginfo + String.format("  %s: %s\n", item.getKey(), id);
                continue;
            }
            if (value instanceof HandlerConfiguration) {
                HandlerConfiguration hconfig = (HandlerConfiguration)value;
                if (hconfig == null) continue;
                loginfo = loginfo + String.format("  %s:\n", item.getKey());
                for (String role : hconfig.getRoles()) {
                    loginfo = loginfo + String.format("    %s\n", role);
                }
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                if (list == null) continue;
                loginfo = loginfo + String.format("  %s:\n", item.getKey());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    loginfo = loginfo + String.format("    %s\n", iterator.next());
                }
                continue;
            }
            if (value instanceof WeakReference) {
                ref = ((WeakReference)value).get();
                if (!(ref instanceof ClientInstance)) continue;
                ClientInstance ci = (ClientInstance)ref;
                ClientInstanceIdentity id = ci.getId();
                String idvalue = id.toString();
                if (value.equals("none")) continue;
                loginfo = loginfo + String.format("  %s: %s\n", item.getKey(), idvalue);
                continue;
            }
            if (value instanceof OracleDispatchImpl) {
                try {
                    OracleDispatchImpl dispatch = (OracleDispatchImpl)value;
                    if (!s_getPolicyAttachmentsMethodFound.booleanValue()) continue;
                    List policies = (List)s_getPolicyAttachmentsMethod.invoke((Object)dispatch.getPolicySet(), new Object[0]);
                    for (IPolicyAttachment policy : policies) {
                        List references = policy.getPolicyReferences();
                        for (IPolicyReference ref2 : references) {
                            loginfo = loginfo + String.format("  PolicyAttachment: %s\n", ref2.getPolicyURI());
                        }
                    }
                    continue;
                }
                catch (Throwable t) {
                    continue;
                }
            }
            if (value instanceof Element) {
                try {
                    TransformerFactory tfactory = TransformerFactory.newInstance();
                    Transformer xform = tfactory.newTransformer();
                    DOMSource src = new DOMSource((Element)value);
                    StringWriter writer = new StringWriter();
                    StreamResult result = new StreamResult(writer);
                    xform.transform(src, result);
                    loginfo = loginfo + String.format("  %s:\n%s\n", item.getKey(), writer.toString());
                }
                catch (TransformerConfigurationException e) {
                    loginfo = loginfo + String.format("  %s\nCannot display because: %s\n", item.getKey(), e.getMessage());
                }
                catch (TransformerException e) {
                    loginfo = loginfo + String.format("  %s\nCannot display because: %s\n", item.getKey(), e.getMessage());
                }
                continue;
            }
            if (value instanceof Message11) {
                try {
                    Message11 message = (Message11)value;
                    loginfo = loginfo + String.format("  %s (headers):\n", item.getKey());
                    Iterator iter = message.getMimeHeaders().getAllHeaders();
                    while (iter.hasNext()) {
                        MimeHeader mimeheader = (MimeHeader)iter.next();
                        loginfo = loginfo + String.format("    %s: %s\n", mimeheader.getName(), mimeheader.getValue());
                    }
                    continue;
                }
                catch (LinkageError le) {
                    loginfo = loginfo + "Java 1.6 or greater is needed to use oracle.j2ee.ws.saaj.soap.soap11.Message11";
                    continue;
                }
                catch (Throwable t) {
                    continue;
                }
            }
            if (value == null || value.equals("none")) continue;
            if (item.getKey().contains("assword")) {
                value = "******";
            }
            loginfo = loginfo + String.format("  %s: %s\n", item.getKey(), value);
        }
        return loginfo;
    }

    static {
        try {
            s_getPolicyAttachmentsMethod = IPolicySet.class.getDeclaredMethod("getPolicyAttachments", new Class[0]);
            s_getPolicyAttachmentsMethodFound = s_getPolicyAttachmentsMethod == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        catch (Throwable t) {
            s_getPolicyAttachmentsMethodFound = false;
        }
    }
}

