/*
 * Decompiled with CFR 0.152.
 */
package oracle.stellent.ridc.protocol.jaxws.stack.jrf;

import HTTPClient.Cookie;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import oracle.stellent.ridc.RIDCCookie;
import oracle.stellent.ridc.common.util.StringTools;
import oracle.stellent.ridc.model.DataFactory;
import oracle.stellent.ridc.protocol.ProtocolException;
import oracle.stellent.ridc.protocol.ServiceRequest;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClient;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConfig;
import oracle.stellent.ridc.protocol.jaxws.JaxWSClientConnection;
import oracle.stellent.ridc.protocol.jaxws.JaxWSProtocol;
import oracle.stellent.ridc.protocol.jaxws.obj.IdcWebLogin;
import oracle.stellent.ridc.protocol.jaxws.stack.wls.JaxWSwlsServiceStack;
import oracle.webservices.ClientFactory;
import oracle.webservices.ImplType;
import oracle.webservices.WsMetaFactory;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;

public class JaxWSbkServiceStack
extends JaxWSwlsServiceStack {
    public JaxWSbkServiceStack(ServiceRequest<JaxWSClientConnection> serviceRequest, DataFactory dataFactory, JaxWSClientConfig config, JaxWSProtocol protocol) throws ProtocolException {
        super(serviceRequest, dataFactory, config, protocol);
    }

    @Override
    public boolean saveCookiesToUserContext(IdcWebLogin loginPort) {
        Map requestContext = ((BindingProvider)loginPort).getRequestContext();
        Map cookies = (Map)requestContext.get("oracle.webservices.cookieMap");
        if (cookies == null || cookies.isEmpty()) {
            this.logCookieWarning();
            return false;
        }
        HashMap<String, RIDCCookie> cookieMap = new HashMap<String, RIDCCookie>();
        for (Map.Entry entry : cookies.entrySet()) {
            Cookie cookie = (Cookie)entry.getKey();
            int maxAge = -1;
            RIDCCookie idcCookie = new RIDCCookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), maxAge, cookie.isSecure());
            cookieMap.put(cookie.getName(), idcCookie);
        }
        this.getServiceRequest().getUserContext().setCookies(cookieMap);
        if (null == this.getServiceRequest().getUserContext().getCookie(this.getServiceRequest().getUserContext().getSessionCookie())) {
            this.logCookieWarning();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IdcWebLogin getLoginPort() throws ProtocolException {
        IdcWebLogin loginPort;
        try {
            JaxWSClient client = (JaxWSClient)this.getProtocol().getClient();
            Map<String, Service> servicesMap = client.getServicesMap();
            JaxWSClientConfig config = this.getClientConfig();
            String url = config.getLoginServiceWSDLUrl();
            Service service = servicesMap.get(url);
            if (service == null) {
                String syncObject;
                String string = syncObject = (this.getClass().getName() + "#getLoginPort#" + url).intern();
                synchronized (string) {
                    service = servicesMap.get(url);
                    if (service == null) {
                        WsMetaFactory jrfWsMetaFactory = WsMetaFactory.newInstance((ImplType)ImplType.JRF);
                        ClientFactory jrfClientFactory = jrfWsMetaFactory.createClientFactory();
                        QName loginServiceQName = new QName(config.getLoginNamespaceUri(), config.getLoginServiceName());
                        service = jrfClientFactory.create(new URL(url), loginServiceQName);
                        servicesMap.put(url, service);
                    }
                }
            }
            QName loginPortQName = new QName(config.getLoginNamespaceUri(), config.getLoginServicePort());
            SecurityPolicyFeature securityFeature = null;
            if (!StringTools.isEmpty(config.getClientSecurityPolicy())) {
                securityFeature = new SecurityPolicyFeature(config.getClientSecurityPolicy());
            }
            loginPort = (IdcWebLogin)service.getPort(loginPortQName, IdcWebLogin.class, new WebServiceFeature[]{securityFeature});
            Map requestContext = ((BindingProvider)loginPort).getRequestContext();
            requestContext.put("oracle.webservices.httpReadTimeout", new Integer(config.getSocketTimeout()));
            requestContext.put("oracle.webservices.httpConnTimeout", new Integer(config.getSocketTimeout()));
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        return loginPort;
    }

    @Override
    public String getLoginStackNameForLog() {
        return JaxWSClientConfig.JAXWSSTACK.jrf.toString();
    }
}

